/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.netty.resolver.dns;

import com.shaded.netty.channel.Channel;
import com.shaded.netty.channel.EventLoop;
import com.shaded.netty.handler.codec.dns.DnsRecord;
import com.shaded.netty.handler.codec.dns.DnsRecordType;
import com.shaded.netty.resolver.dns.AuthoritativeDnsServerCache;
import com.shaded.netty.resolver.dns.DnsAddressDecoder;
import com.shaded.netty.resolver.dns.DnsCache;
import com.shaded.netty.resolver.dns.DnsNameResolver;
import com.shaded.netty.resolver.dns.DnsResolveContext;
import com.shaded.netty.resolver.dns.DnsServerAddressStream;
import com.shaded.netty.resolver.dns.PreferredAddressTypeComparator;
import com.shaded.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;

final class DnsAddressResolveContext
extends DnsResolveContext<InetAddress> {
    private final DnsCache resolveCache;
    private final AuthoritativeDnsServerCache authoritativeDnsServerCache;
    private final boolean completeEarlyIfPossible;

    DnsAddressResolveContext(DnsNameResolver parent, Channel channel, Promise<?> originalPromise, String hostname, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries, DnsCache resolveCache, AuthoritativeDnsServerCache authoritativeDnsServerCache, boolean completeEarlyIfPossible) {
        super(parent, channel, originalPromise, hostname, 1, parent.resolveRecordTypes(), additionals, nameServerAddrs, allowedQueries);
        this.resolveCache = resolveCache;
        this.authoritativeDnsServerCache = authoritativeDnsServerCache;
        this.completeEarlyIfPossible = completeEarlyIfPossible;
    }

    @Override
    DnsResolveContext<InetAddress> newResolverContext(DnsNameResolver parent, Channel channel, Promise<?> originalPromise, String hostname, int dnsClass, DnsRecordType[] expectedTypes, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        return new DnsAddressResolveContext(parent, channel, originalPromise, hostname, additionals, nameServerAddrs, allowedQueries, this.resolveCache, this.authoritativeDnsServerCache, this.completeEarlyIfPossible);
    }

    @Override
    InetAddress convertRecord(DnsRecord record, String hostname, DnsRecord[] additionals, EventLoop eventLoop) {
        return DnsAddressDecoder.decodeAddress(record, hostname, this.parent.isDecodeIdn());
    }

    @Override
    List<InetAddress> filterResults(List<InetAddress> unfiltered) {
        Collections.sort(unfiltered, PreferredAddressTypeComparator.comparator(this.parent.preferredAddressType()));
        return unfiltered;
    }

    @Override
    boolean isCompleteEarly(InetAddress resolved) {
        return this.completeEarlyIfPossible && this.parent.preferredAddressType().addressType() == resolved.getClass();
    }

    @Override
    boolean isDuplicateAllowed() {
        return false;
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, DnsRecord result, InetAddress convertedResult) {
        this.resolveCache.cache(hostname, additionals, convertedResult, result.timeToLive(), this.channel().eventLoop());
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, UnknownHostException cause) {
        this.resolveCache.cache(hostname, additionals, cause, this.channel().eventLoop());
    }

    @Override
    void doSearchDomainQuery(String hostname, Promise<List<InetAddress>> nextPromise) {
        if (!DnsNameResolver.doResolveAllCached(hostname, this.additionals, nextPromise, this.resolveCache, this.parent.searchDomains(), this.parent.ndots(), this.parent.resolvedInternetProtocolFamiliesUnsafe())) {
            super.doSearchDomainQuery(hostname, nextPromise);
        }
    }

    @Override
    DnsCache resolveCache() {
        return this.resolveCache;
    }

    @Override
    AuthoritativeDnsServerCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }
}

