/*
 * Decompiled with CFR 0.152.
 */
package com.applitools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class ReplacePrefixResourceTransformer
implements ResourceTransformer {
    private TransformerConfig config;
    private final Map<String, StringBuilder> transformedResources = new HashMap<String, StringBuilder>();

    public ReplacePrefixResourceTransformer() {
        System.out.println("ReplacePrefixResourceTransformer ctor");
    }

    public void setConfig(TransformerConfig config) {
        this.config = config;
    }

    public TransformerConfig getConfig() {
        return this.config;
    }

    public boolean canTransformResource(String resource) {
        return this.config.getTargetResources().contains(resource);
    }

    public void processResource(String resource, InputStream inputStream, List<Relocator> relocators) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                for (ReplacementConfig replacement : this.config.getReplacements()) {
                    line = line.replace(replacement.getKey(), replacement.getValue());
                }
                content.append(line).append(System.lineSeparator());
            }
        }
        this.transformedResources.put(resource, content);
    }

    public boolean hasTransformedResource() {
        return !this.transformedResources.isEmpty();
    }

    public void modifyOutputStream(JarOutputStream jarOutputStream) throws IOException {
        for (Map.Entry<String, StringBuilder> entry : this.transformedResources.entrySet()) {
            jarOutputStream.putNextEntry(new JarEntry(entry.getKey()));
            jarOutputStream.write(entry.getValue().toString().getBytes());
            jarOutputStream.closeEntry();
        }
    }

    public static class TransformerConfig {
        private List<ReplacementConfig> replacements;
        private List<String> targetResources;

        public List<ReplacementConfig> getReplacements() {
            return this.replacements;
        }

        public void setReplacements(List<ReplacementConfig> replacements) {
            this.replacements = replacements;
        }

        public List<String> getTargetResources() {
            return this.targetResources;
        }

        public void setTargetResources(List<String> targetResources) {
            this.targetResources = targetResources;
        }
    }

    public static class ReplacementConfig {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

