/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.DensityMetrics;
import com.applitools.eyes.DynamicRegionByRectangle;
import com.applitools.eyes.DynamicTextType;
import com.applitools.eyes.LazyLoadOptions;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.applitools.eyes.StitchOverlap;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.IGetDynamicTextType;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.visualgrid.model.VisualGridOption;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CheckSettings
implements ICheckSettings,
ICheckSettingsInternal {
    protected static final String BEFORE_CAPTURE_SCREENSHOT = "beforeCaptureScreenshot";
    private Region targetRegion;
    private Boolean stitchContent = null;
    private StitchMode stitchMode;
    private Boolean hideScrollBars;
    private Boolean hideCaret;
    private StitchOverlap overlap;
    private Integer waitBeforeCapture;
    private LazyLoadOptions lazyLoadOptions;
    protected Boolean ignoreDisplacements;
    private Map<String, String> debugImages;
    protected String name;
    protected String pageId;
    protected final List<GetRegion> ignoreRegions = new ArrayList<GetRegion>();
    protected final List<GetRegion> layoutRegions = new ArrayList<GetRegion>();
    protected final List<GetRegion> strictRegions = new ArrayList<GetRegion>();
    protected final List<GetRegion> contentRegions = new ArrayList<GetRegion>();
    protected final List<GetRegion> floatingRegions = new ArrayList<GetRegion>();
    protected final List<GetRegion> accessibilityRegions = new ArrayList<GetRegion>();
    protected final List<GetRegion> dynamicRegions = new ArrayList<GetRegion>();
    private MatchLevel matchLevel = null;
    private AccessibilitySettings accessibilitySettings;
    private Integer retryTimeout = null;
    protected Boolean sendDom;
    protected Boolean useDom;
    protected Boolean enablePatterns;
    private Boolean ignoreCaret;
    private List<VisualGridOption> ufgOptions = new ArrayList<VisualGridOption>();
    private LayoutBreakpointsOptions layoutBreakpointsOptions;
    private Boolean disableBrowserFetching;
    private AutProxySettings autProxy;
    protected Map<String, String> scriptHooks = new HashMap<String, String>();
    private BaseOcrRegion ocrRegion = null;
    private String variationGroupId = null;
    private DensityMetrics densityMetrics;

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(Integer retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    protected void ignore_(Region region) {
        this.ignore_(new SimpleRegionByRectangle(region));
    }

    protected void ignore_(GetRegion regionProvider) {
        this.ignoreRegions.add(regionProvider);
    }

    protected void layout_(Region region) {
        this.layout_(new SimpleRegionByRectangle(region));
    }

    protected void layout_(GetRegion regionProvider) {
        this.layoutRegions.add(regionProvider);
    }

    protected void content_(Region region) {
        this.content_(new SimpleRegionByRectangle(region));
    }

    protected void content_(GetRegion regionProvider) {
        this.contentRegions.add(regionProvider);
    }

    protected void strict_(Region region) {
        this.strict_(new SimpleRegionByRectangle(region));
    }

    protected void strict_(GetRegion regionProvider) {
        this.strictRegions.add(regionProvider);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    protected void dynamic_(Region region, DynamicTextType ... textTypes) {
        this.dynamic_(new DynamicRegionByRectangle(region, textTypes));
    }

    protected void dynamic_(IGetDynamicTextType regionProvider) {
        this.dynamicRegions.add(regionProvider);
    }

    protected void floating(GetRegion regionProvider) {
        this.floatingRegions.add(regionProvider);
    }

    @Override
    public CheckSettings clone() {
        CheckSettings clone = new CheckSettings();
        this.populateClone(clone);
        return clone;
    }

    @Override
    public Boolean isStitchContent() {
        return this.stitchContent;
    }

    @Override
    public ICheckSettings ignore(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.ignore_(region);
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings ignore(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings layout(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.layout_(region);
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings layout(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings strict(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.strict_(region);
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings strict(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings content(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.content_(region);
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings content(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings fully() {
        CheckSettings clone = this.clone();
        clone.stitchContent = true;
        return clone;
    }

    @Override
    public ICheckSettings fully(Boolean fully) {
        CheckSettings clone = this.clone();
        clone.stitchContent = fully;
        return clone;
    }

    @Override
    public ICheckSettings floating(int maxOffset, Region ... regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return clone;
    }

    @Override
    public ICheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        CheckSettings clone = this.clone();
        clone.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return clone;
    }

    @Override
    public ICheckSettings timeout(Integer timeoutMilliseconds) {
        CheckSettings clone = this.clone();
        clone.retryTimeout = timeoutMilliseconds;
        return clone;
    }

    @Override
    public ICheckSettings layout() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.LAYOUT;
        return clone;
    }

    @Override
    public ICheckSettings dynamic() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.DYNAMIC;
        return clone;
    }

    @Override
    public ICheckSettings exact() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.EXACT;
        return clone;
    }

    @Override
    public ICheckSettings strict() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.STRICT;
        return clone;
    }

    @Override
    public ICheckSettings content() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.IGNORE_COLORS;
        return clone;
    }

    public ICheckSettings ignoreColors() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.IGNORE_COLORS;
        return clone;
    }

    @Override
    public ICheckSettings matchLevel(MatchLevel matchLevel) {
        CheckSettings clone = this.clone();
        clone.matchLevel = matchLevel;
        return clone;
    }

    @Override
    public ICheckSettings ignoreCaret(Boolean ignoreCaret) {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = ignoreCaret;
        return clone;
    }

    @Override
    public ICheckSettings ignoreCaret() {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = true;
        return clone;
    }

    @Override
    public ICheckSettings withName(String name) {
        CheckSettings clone = this.clone();
        clone.name = name;
        return clone;
    }

    @Override
    public Boolean isSendDom() {
        return this.sendDom;
    }

    @Override
    public Boolean isIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public Boolean isUseDom() {
        return this.useDom;
    }

    @Override
    public ICheckSettings useDom(Boolean useDom) {
        CheckSettings clone = this.clone();
        clone.useDom = useDom;
        return clone;
    }

    @Override
    public ICheckSettings sendDom(Boolean sendDom) {
        CheckSettings clone = this.clone();
        clone.sendDom = sendDom;
        return clone;
    }

    @Override
    public ICheckSettings sendDom() {
        return this.sendDom(true);
    }

    @Override
    public Region getTargetRegion() {
        return this.targetRegion;
    }

    @Override
    public Integer getTimeout() {
        return this.retryTimeout;
    }

    @Override
    public Boolean getStitchContent() {
        return this.stitchContent;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public GetRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getStrictRegions() {
        return this.strictRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getLayoutRegions() {
        return this.layoutRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getContentRegions() {
        return this.contentRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetRegion[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getScriptHooks() {
        return this.scriptHooks;
    }

    @Override
    public String getSizeMode() {
        return null;
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }

    protected void populateClone(CheckSettings clone) {
        clone.targetRegion = this.targetRegion;
        clone.matchLevel = this.matchLevel;
        clone.stitchContent = this.stitchContent;
        clone.retryTimeout = this.retryTimeout;
        clone.ignoreCaret = this.ignoreCaret;
        clone.name = this.name;
        clone.pageId = this.pageId;
        clone.ignoreRegions.addAll(this.ignoreRegions);
        clone.contentRegions.addAll(this.contentRegions);
        clone.layoutRegions.addAll(this.layoutRegions);
        clone.strictRegions.addAll(this.strictRegions);
        clone.floatingRegions.addAll(this.floatingRegions);
        clone.accessibilityRegions.addAll(this.accessibilityRegions);
        clone.dynamicRegions.addAll(this.dynamicRegions);
        clone.scriptHooks.putAll(this.scriptHooks);
        clone.enablePatterns = this.enablePatterns;
        clone.ignoreDisplacements = this.ignoreDisplacements;
        clone.useDom = this.useDom;
        clone.ufgOptions = this.ufgOptions;
        clone.ocrRegion = this.ocrRegion;
        clone.variationGroupId = this.variationGroupId;
        clone.disableBrowserFetching = this.disableBrowserFetching;
        clone.waitBeforeCapture = this.waitBeforeCapture;
        clone.lazyLoadOptions = this.lazyLoadOptions;
        clone.densityMetrics = this.densityMetrics;
        clone.overlap = this.overlap;
        clone.layoutBreakpointsOptions = this.layoutBreakpointsOptions;
        clone.stitchMode = this.stitchMode;
    }

    public void setStitchContent(boolean stitchContent) {
        this.stitchContent = stitchContent;
    }

    @Override
    public Boolean isEnablePatterns() {
        return this.enablePatterns;
    }

    @Override
    public ICheckSettings enablePatterns(Boolean enablePatterns) {
        CheckSettings clone = this.clone();
        clone.enablePatterns = enablePatterns;
        return clone;
    }

    @Override
    public ICheckSettings enablePatterns() {
        CheckSettings clone = this.clone();
        clone.enablePatterns = true;
        return clone;
    }

    @Override
    @Deprecated
    public ICheckSettings scriptHook(String hook) {
        return this.beforeRenderScreenshotHook(hook);
    }

    @Override
    public ICheckSettings beforeRenderScreenshotHook(String hook) {
        CheckSettings clone = this.clone();
        clone.scriptHooks.put(BEFORE_CAPTURE_SCREENSHOT, hook);
        return clone;
    }

    @Override
    public ICheckSettings ignoreDisplacements(Boolean ignoreDisplacements) {
        CheckSettings clone = this.clone();
        clone.ignoreDisplacements = ignoreDisplacements;
        return clone;
    }

    @Override
    public ICheckSettings ignoreDisplacements() {
        return this.ignoreDisplacements(true);
    }

    protected void accessibility_(GetRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    protected void accessibility_(Region rect, AccessibilityRegionType regionType) {
        this.accessibility_(new AccessibilityRegionByRectangle(rect, regionType));
    }

    @Override
    public ICheckSettings accessibility(Region region, AccessibilityRegionType regionType) {
        CheckSettings clone = this.clone();
        clone.accessibility_(region, regionType);
        return clone;
    }

    protected void accessibility(GetRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    @Override
    public GetRegion[] getAccessibilityRegions() {
        return this.accessibilityRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getDynamicRegions() {
        return this.dynamicRegions.toArray(new GetRegion[0]);
    }

    public ICheckSettings ocrRegion(BaseOcrRegion ocrRegion) {
        CheckSettings clone = this.clone();
        clone.ocrRegion = ocrRegion;
        return clone;
    }

    @Override
    public BaseOcrRegion getOcrRegion() {
        return this.ocrRegion;
    }

    public ICheckSettings variationGroupId(String variationGroupId) {
        CheckSettings clone = this.clone();
        clone.variationGroupId = variationGroupId;
        return clone;
    }

    @Override
    public String getVariationGroupId() {
        return this.variationGroupId;
    }

    @Override
    @JsonIgnore
    public PositionProvider getStepPositionProvider() {
        return null;
    }

    @Override
    public ICheckSettings visualGridOptions(VisualGridOption ... options) {
        CheckSettings clone = this.clone();
        clone.ufgOptions.clear();
        if (options != null) {
            clone.ufgOptions.addAll(Arrays.asList(options));
            clone.ufgOptions.remove(null);
        }
        return clone;
    }

    @Override
    public Boolean isCheckWindow() {
        return this.getTargetRegion() == null;
    }

    @Override
    public ICheckSettings waitBeforeCapture(Integer milliSec) {
        CheckSettings clone = this.clone();
        clone.waitBeforeCapture = milliSec;
        return clone;
    }

    @Override
    public List<VisualGridOption> getVisualGridOptions() {
        return this.ufgOptions;
    }

    @Override
    public Boolean isDisableBrowserFetching() {
        return this.disableBrowserFetching;
    }

    @Override
    public ICheckSettings setDisableBrowserFetching(Boolean disableBrowserFetching) {
        CheckSettings clone = this.clone();
        clone.disableBrowserFetching = disableBrowserFetching;
        return clone;
    }

    public Integer getWaitBeforeCapture() {
        return this.waitBeforeCapture;
    }

    @Override
    public ICheckSettings lazyLoad() {
        CheckSettings clone = this.clone();
        clone.lazyLoadOptions = new LazyLoadOptions();
        return clone;
    }

    @Override
    public ICheckSettings lazyLoad(LazyLoadOptions lazyLoadOptions) {
        CheckSettings clone = this.clone();
        clone.lazyLoadOptions = lazyLoadOptions;
        return clone;
    }

    public LazyLoadOptions getLazyLoadOptions() {
        return this.lazyLoadOptions;
    }

    public AutProxySettings getAutProxy() {
        return this.autProxy;
    }

    public ICheckSettings autProxy(AutProxySettings autProxy) {
        CheckSettings clone = this.clone();
        clone.autProxy = autProxy;
        return clone;
    }

    public AccessibilitySettings getAccessibilityValidation() {
        return this.accessibilitySettings;
    }

    public ICheckSettings setAccessibilityValidation(AccessibilitySettings accessibilitySettings) {
        if (accessibilitySettings == null) {
            return this;
        }
        if (accessibilitySettings.getLevel() == null || accessibilitySettings.getGuidelinesVersion() == null) {
            throw new IllegalArgumentException("AccessibilitySettings should have the following properties: \u2018level,version\u2019");
        }
        CheckSettings clone = this.clone();
        clone.accessibilitySettings = accessibilitySettings;
        return clone;
    }

    public StitchMode getStitchMode() {
        return this.stitchMode;
    }

    public ICheckSettings stitchMode(StitchMode stitchMode) {
        CheckSettings clone = this.clone();
        clone.stitchMode = stitchMode;
        return clone;
    }

    public Boolean getHideScrollBars() {
        return this.hideScrollBars;
    }

    public ICheckSettings hideScrollBars(Boolean hideScrollBars) {
        CheckSettings clone = this.clone();
        clone.hideScrollBars = hideScrollBars;
        return clone;
    }

    @Deprecated
    public ICheckSettings setHideScrollBars(Boolean hideScrollBars) {
        CheckSettings clone = this.clone();
        clone.hideScrollBars = hideScrollBars;
        return clone;
    }

    public Boolean getHideCaret() {
        return this.hideCaret;
    }

    public ICheckSettings hideCaret(Boolean hideCaret) {
        CheckSettings clone = this.clone();
        clone.hideCaret = hideCaret;
        return clone;
    }

    @Deprecated
    public ICheckSettings setHideCaret(Boolean hideCaret) {
        CheckSettings clone = this.clone();
        clone.hideCaret = hideCaret;
        return clone;
    }

    public Integer getOverlap() {
        return this.overlap.getBottom();
    }

    public StitchOverlap getStitchOverlap() {
        return this.overlap;
    }

    public ICheckSettings setOverlap(Integer overlap) {
        CheckSettings clone = this.clone();
        clone.overlap = new StitchOverlap().bottom(overlap);
        return clone;
    }

    public ICheckSettings stitchOverlap(Integer overlap) {
        CheckSettings clone = this.clone();
        clone.overlap = new StitchOverlap().bottom(overlap);
        return clone;
    }

    public ICheckSettings stitchOverlap(StitchOverlap stitchOverlap) {
        CheckSettings clone = this.clone();
        clone.overlap = stitchOverlap;
        return clone;
    }

    @Override
    public ICheckSettings layoutBreakpoints(Boolean shouldSet) {
        return this.layoutBreakpoints(new LayoutBreakpointsOptions().breakpoints(shouldSet));
    }

    @Override
    public ICheckSettings region(Region region) {
        CheckSettings clone = this.clone();
        clone.targetRegion = region;
        return clone;
    }

    @Override
    public ICheckSettings layoutBreakpoints(Integer ... breakpoints) {
        return this.layoutBreakpoints(new LayoutBreakpointsOptions().breakpoints(breakpoints));
    }

    public ICheckSettings layoutBreakpoints(int[] breakpoints) {
        return this.layoutBreakpoints(new LayoutBreakpointsOptions().breakpoints(breakpoints));
    }

    @Deprecated
    public ICheckSettings setLayoutBreakpoints(Boolean shouldSet) {
        return this.layoutBreakpoints(new LayoutBreakpointsOptions().breakpoints(shouldSet));
    }

    @Deprecated
    public ICheckSettings setLayoutBreakpoints(Integer ... breakpoints) {
        return this.layoutBreakpoints(new LayoutBreakpointsOptions().breakpoints(breakpoints));
    }

    @Deprecated
    public ICheckSettings setLayoutBreakpoints(int ... breakpoints) {
        return this.layoutBreakpoints(new LayoutBreakpointsOptions().breakpoints(breakpoints));
    }

    @Override
    public ICheckSettings layoutBreakpoints(LayoutBreakpointsOptions layoutBreakpointsOptions) {
        CheckSettings clone = this.clone();
        clone.layoutBreakpointsOptions = layoutBreakpointsOptions;
        return clone;
    }

    public Boolean isDefaultLayoutBreakpointsSet() {
        return this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.isLayoutBreakpoints() : null;
    }

    public List<Integer> getLayoutBreakpoints() {
        return this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.getLayoutBreakpoints() : new ArrayList();
    }

    public LayoutBreakpointsOptions getLayoutBreakpointsOptions() {
        return this.layoutBreakpointsOptions;
    }

    public ICheckSettings pageId(String pageId) {
        CheckSettings clone = this.clone();
        clone.pageId = pageId;
        return clone;
    }

    public String getPageId() {
        return this.pageId;
    }

    @Override
    public ICheckSettings densityMetrics(int xDpi, int yDpi) {
        CheckSettings clone = this.clone();
        clone.densityMetrics = new DensityMetrics(xDpi, yDpi);
        return clone;
    }

    @Override
    public ICheckSettings densityMetrics(int xDpi, int yDpi, Double scaleRatio) {
        CheckSettings clone = this.clone();
        clone.densityMetrics = new DensityMetrics(xDpi, yDpi).scaleRatio(scaleRatio);
        return clone;
    }

    public DensityMetrics getDensityMetrics() {
        return this.densityMetrics;
    }

    protected ICheckSettings dynamic(Region region, DynamicTextType ... textTypes) {
        CheckSettings clone = this.clone();
        clone.dynamic_(region, textTypes);
        return clone;
    }
}

