/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient;

import com.shaded.asynchttpclient.HttpResponseBodyPart;
import com.shaded.asynchttpclient.HttpResponseStatus;
import com.shaded.asynchttpclient.netty.NettyResponse;
import com.shaded.asynchttpclient.uri.Uri;
import com.shaded.jetbrains.annotations.Nullable;
import com.shaded.netty.buffer.ByteBuf;
import com.shaded.netty.handler.codec.http.HttpHeaders;
import com.shaded.netty.handler.codec.http.cookie.Cookie;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public interface Response {
    public int getStatusCode();

    public String getStatusText();

    public byte[] getResponseBodyAsBytes();

    public ByteBuffer getResponseBodyAsByteBuffer();

    public ByteBuf getResponseBodyAsByteBuf();

    public InputStream getResponseBodyAsStream();

    public String getResponseBody(Charset var1);

    public String getResponseBody();

    public Uri getUri();

    public String getContentType();

    public String getHeader(CharSequence var1);

    public List<String> getHeaders(CharSequence var1);

    public HttpHeaders getHeaders();

    public boolean isRedirected();

    public String toString();

    public List<Cookie> getCookies();

    public boolean hasResponseStatus();

    public boolean hasResponseHeaders();

    public boolean hasResponseBody();

    public SocketAddress getRemoteAddress();

    public SocketAddress getLocalAddress();

    public static class ResponseBuilder {
        private final List<HttpResponseBodyPart> bodyParts = new ArrayList<HttpResponseBodyPart>(1);
        @Nullable
        private HttpResponseStatus status;
        @Nullable
        private HttpHeaders headers;

        public void accumulate(HttpResponseStatus status) {
            this.status = status;
        }

        public void accumulate(HttpHeaders headers) {
            this.headers = this.headers == null ? headers : this.headers.add(headers);
        }

        public void accumulate(HttpResponseBodyPart bodyPart) {
            if (bodyPart.length() > 0) {
                this.bodyParts.add(bodyPart);
            }
        }

        @Nullable
        public Response build() {
            return this.status == null ? null : new NettyResponse(this.status, this.headers, this.bodyParts);
        }

        public void reset() {
            this.bodyParts.clear();
            this.status = null;
            this.headers = null;
        }
    }
}

