/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.channel;

import com.shaded.asynchttpclient.proxy.ProxyServer;
import com.shaded.asynchttpclient.proxy.ProxyType;
import com.shaded.asynchttpclient.uri.Uri;
import com.shaded.jetbrains.annotations.Nullable;
import java.util.Objects;

@FunctionalInterface
public interface ChannelPoolPartitioning {
    public Object getPartitionKey(Uri var1, String var2, ProxyServer var3);

    public static class CompositePartitionKey {
        private final String targetHostBaseUrl;
        @Nullable
        private final String virtualHost;
        @Nullable
        private final String proxyHost;
        private final int proxyPort;
        @Nullable
        private final ProxyType proxyType;

        CompositePartitionKey(String targetHostBaseUrl, @Nullable String virtualHost, @Nullable String proxyHost, int proxyPort, @Nullable ProxyType proxyType) {
            this.targetHostBaseUrl = targetHostBaseUrl;
            this.virtualHost = virtualHost;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyType = proxyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositePartitionKey that = (CompositePartitionKey)o;
            if (this.proxyPort != that.proxyPort) {
                return false;
            }
            if (!Objects.equals(this.targetHostBaseUrl, that.targetHostBaseUrl)) {
                return false;
            }
            if (!Objects.equals(this.virtualHost, that.virtualHost)) {
                return false;
            }
            if (!Objects.equals(this.proxyHost, that.proxyHost)) {
                return false;
            }
            return this.proxyType == that.proxyType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetHostBaseUrl, this.virtualHost, this.proxyHost, this.proxyPort, this.proxyType});
        }

        public String toString() {
            return "CompositePartitionKey(targetHostBaseUrl=" + this.targetHostBaseUrl + ", virtualHost=" + this.virtualHost + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyType=" + this.proxyType;
        }
    }

    public static enum PerHostChannelPoolPartitioning implements ChannelPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, @Nullable String virtualHost, @Nullable ProxyServer proxyServer) {
            String targetHostBaseUrl = uri.getBaseUrl();
            if (proxyServer == null) {
                if (virtualHost == null) {
                    return targetHostBaseUrl;
                }
                return new CompositePartitionKey(targetHostBaseUrl, virtualHost, null, 0, null);
            }
            return new CompositePartitionKey(targetHostBaseUrl, virtualHost, proxyServer.getHost(), uri.isSecured() && proxyServer.getProxyType() == ProxyType.HTTP ? proxyServer.getSecuredPort() : proxyServer.getPort(), proxyServer.getProxyType());
        }
    }
}

