/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.netty.channel;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.AsyncHttpClientState;
import com.shaded.asynchttpclient.netty.SimpleChannelFutureListener;
import com.shaded.asynchttpclient.netty.channel.NettyConnectListener;
import com.shaded.netty.bootstrap.Bootstrap;
import com.shaded.netty.channel.Channel;
import com.shaded.slf4j.Logger;
import com.shaded.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class NettyChannelConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyChannelConnector.class);
    private static final AtomicIntegerFieldUpdater<NettyChannelConnector> I_UPDATER = AtomicIntegerFieldUpdater.newUpdater(NettyChannelConnector.class, "i");
    private final AsyncHandler<?> asyncHandler;
    private final InetSocketAddress localAddress;
    private final List<InetSocketAddress> remoteAddresses;
    private final AsyncHttpClientState clientState;
    private volatile int i;

    public NettyChannelConnector(InetAddress localAddress, List<InetSocketAddress> remoteAddresses, AsyncHandler<?> asyncHandler, AsyncHttpClientState clientState) {
        this.localAddress = localAddress != null ? new InetSocketAddress(localAddress, 0) : null;
        this.remoteAddresses = remoteAddresses;
        this.asyncHandler = asyncHandler;
        this.clientState = clientState;
    }

    private boolean pickNextRemoteAddress() {
        I_UPDATER.incrementAndGet(this);
        return this.i < this.remoteAddresses.size();
    }

    public void connect(Bootstrap bootstrap, NettyConnectListener<?> connectListener) {
        InetSocketAddress remoteAddress = this.remoteAddresses.get(this.i);
        try {
            this.asyncHandler.onTcpConnectAttempt(remoteAddress);
        }
        catch (Exception e) {
            LOGGER.error("onTcpConnectAttempt crashed", e);
            connectListener.onFailure(null, e);
            return;
        }
        try {
            this.connect0(bootstrap, connectListener, remoteAddress);
        }
        catch (RejectedExecutionException e) {
            if (this.clientState.isClosed()) {
                LOGGER.info("Connect crash but engine is shutting down");
            }
            connectListener.onFailure(null, e);
        }
    }

    private void connect0(final Bootstrap bootstrap, final NettyConnectListener<?> connectListener, final InetSocketAddress remoteAddress) {
        bootstrap.connect(remoteAddress, this.localAddress).addListener(new SimpleChannelFutureListener(){

            @Override
            public void onSuccess(Channel channel) {
                try {
                    NettyChannelConnector.this.asyncHandler.onTcpConnectSuccess(remoteAddress, channel);
                }
                catch (Exception e) {
                    LOGGER.error("onTcpConnectSuccess crashed", e);
                    connectListener.onFailure(channel, e);
                    return;
                }
                connectListener.onSuccess(channel, remoteAddress);
            }

            @Override
            public void onFailure(Channel channel, Throwable t) {
                try {
                    NettyChannelConnector.this.asyncHandler.onTcpConnectFailure(remoteAddress, t);
                }
                catch (Exception e) {
                    LOGGER.error("onTcpConnectFailure crashed", e);
                    connectListener.onFailure(channel, e);
                    return;
                }
                boolean retry = NettyChannelConnector.this.pickNextRemoteAddress();
                if (retry) {
                    NettyChannelConnector.this.connect(bootstrap, connectListener);
                } else {
                    connectListener.onFailure(channel, t);
                }
            }
        });
    }
}

