/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.netty.timeout;

import com.shaded.asynchttpclient.netty.NettyResponseFuture;
import com.shaded.asynchttpclient.netty.request.NettyRequestSender;
import com.shaded.asynchttpclient.netty.timeout.TimeoutTimerTask;
import com.shaded.asynchttpclient.netty.timeout.TimeoutsHolder;
import com.shaded.asynchttpclient.util.DateUtils;
import com.shaded.asynchttpclient.util.StringBuilderPool;
import com.shaded.netty.util.Timeout;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, long requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Request timeout to ");
        this.appendRemoteAddress(sb);
        String message = sb.append(" after ").append(this.requestTimeout).append(" ms").toString();
        long age = DateUtils.unpreciseMillisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

