/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.ws;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.HttpResponseBodyPart;
import com.shaded.asynchttpclient.HttpResponseStatus;
import com.shaded.asynchttpclient.netty.ws.NettyWebSocket;
import com.shaded.asynchttpclient.util.HttpConstants;
import com.shaded.asynchttpclient.ws.WebSocketListener;
import com.shaded.jetbrains.annotations.Nullable;
import com.shaded.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.List;

public class WebSocketUpgradeHandler
implements AsyncHandler<NettyWebSocket> {
    private final List<WebSocketListener> listeners;
    @Nullable
    private NettyWebSocket webSocket;

    public WebSocketUpgradeHandler(List<WebSocketListener> listeners) {
        this.listeners = listeners;
    }

    protected void setWebSocket0(NettyWebSocket webSocket) {
    }

    protected void onStatusReceived0(HttpResponseStatus responseStatus) throws Exception {
    }

    protected void onHeadersReceived0(HttpHeaders headers) throws Exception {
    }

    protected void onBodyPartReceived0(HttpResponseBodyPart bodyPart) throws Exception {
    }

    protected void onCompleted0() throws Exception {
    }

    protected void onThrowable0(Throwable t) {
    }

    protected void onOpen0() {
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.onStatusReceived0(responseStatus);
        return responseStatus.getStatusCode() == HttpConstants.ResponseStatusCodes.SWITCHING_PROTOCOLS_101 ? AsyncHandler.State.CONTINUE : AsyncHandler.State.ABORT;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        this.onHeadersReceived0(headers);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        this.onBodyPartReceived0(bodyPart);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    @Nullable
    public final NettyWebSocket onCompleted() throws Exception {
        this.onCompleted0();
        return this.webSocket;
    }

    @Override
    public final void onThrowable(Throwable t) {
        this.onThrowable0(t);
        for (WebSocketListener listener : this.listeners) {
            if (this.webSocket != null) {
                this.webSocket.addWebSocketListener(listener);
            }
            listener.onError(t);
        }
    }

    public final void setWebSocket(NettyWebSocket webSocket) {
        this.webSocket = webSocket;
        this.setWebSocket0(webSocket);
    }

    public final void onOpen(NettyWebSocket webSocket) {
        this.onOpen0();
        for (WebSocketListener listener : this.listeners) {
            webSocket.addWebSocketListener(listener);
            listener.onOpen(webSocket);
        }
        webSocket.processBufferedFrames();
    }

    public static final class Builder {
        private final List<WebSocketListener> listeners = new ArrayList<WebSocketListener>(1);

        public Builder addWebSocketListener(WebSocketListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder removeWebSocketListener(WebSocketListener listener) {
            this.listeners.remove(listener);
            return this;
        }

        public WebSocketUpgradeHandler build() {
            return new WebSocketUpgradeHandler(this.listeners);
        }
    }
}

