/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.netty.handler.address;

import com.shaded.netty.channel.ChannelHandler;
import com.shaded.netty.channel.ChannelHandlerContext;
import com.shaded.netty.channel.ChannelOutboundHandlerAdapter;
import com.shaded.netty.channel.ChannelPromise;
import com.shaded.netty.resolver.AddressResolver;
import com.shaded.netty.resolver.AddressResolverGroup;
import com.shaded.netty.util.concurrent.Future;
import com.shaded.netty.util.concurrent.FutureListener;
import com.shaded.netty.util.concurrent.GenericFutureListener;
import com.shaded.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

