/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.DynamicTextType;
import com.applitools.eyes.GetDynamicTextType;
import com.applitools.eyes.Padding;
import com.applitools.eyes.Region;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;

public class DynamicRegionByRectangle
extends GetDynamicTextType {
    @JsonInclude
    private int left;
    @JsonInclude
    private int top;
    @JsonInclude
    private int width;
    @JsonInclude
    private int height;
    @JsonInclude
    private String regionId;
    @JsonInclude
    private Padding padding;

    public DynamicRegionByRectangle() {
        super(null);
    }

    public DynamicRegionByRectangle(int left, int top, int width, int height, DynamicTextType ... textTypes) {
        super(textTypes);
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public DynamicRegionByRectangle(Region region, DynamicTextType ... textTypes) {
        super(textTypes);
        this.setRegion(region);
    }

    public DynamicRegionByRectangle(Region region, Padding padding, DynamicTextType ... textTypes) {
        super(textTypes);
        this.setRegion(region);
        this.padding = padding;
    }

    @JsonIgnore
    public Region getRegion() {
        return new Region(this.left, this.top, this.width, this.height);
    }

    public void setRegion(Region region) {
        this.left = region.getLeft();
        this.top = region.getTop();
        this.width = region.getWidth();
        this.height = region.getHeight();
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "DynamicRegionByRectangle{left=" + this.left + ", top=" + this.top + ", width=" + this.width + ", height=" + this.height + ", dynamicSettings =" + this.dynamicSettings + ", padding =" + this.padding + "}";
    }

    public int hashCode() {
        return this.left * 30000 + this.top * 2000 + this.width * 500 + this.height;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DynamicRegionByRectangle)) {
            return false;
        }
        DynamicRegionByRectangle otherRegion = (DynamicRegionByRectangle)other;
        return otherRegion.width == this.width && otherRegion.height == this.height && otherRegion.left == this.left && otherRegion.top == this.top && Objects.equals(otherRegion.regionId, this.regionId) && Objects.equals(otherRegion.dynamicSettings, this.dynamicSettings) && Objects.equals(otherRegion.padding, this.padding);
    }

    @Override
    public DynamicTextType[] getDynamicTextTypes() {
        return new DynamicTextType[0];
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public void setPadding(Padding padding) {
        this.padding = padding;
    }
}

