/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.dto.Command;
import com.applitools.eyes.universal.dto.EventDto;
import com.applitools.eyes.universal.dto.RequestDto;
import com.applitools.eyes.universal.server.UniversalSdkNativeLoader;
import com.shaded.asynchttpclient.AsyncHttpClient;
import com.shaded.asynchttpclient.DefaultAsyncHttpClientConfig;
import com.shaded.asynchttpclient.Dsl;
import com.shaded.asynchttpclient.ws.WebSocket;
import com.shaded.asynchttpclient.ws.WebSocketUpgradeHandler;
import java.io.IOException;

public class USDKConnection
implements AutoCloseable {
    private WebSocket webSocket;
    protected Logger logger = new Logger();
    private final AbstractSDKListener listener;
    private AsyncHttpClient client;

    public USDKConnection(AbstractSDKListener listener) {
        this.listener = listener;
    }

    public void init() {
        this.webSocket = this.openWebsocket();
        this.listener.setWebSocket(this.webSocket);
    }

    private WebSocket openWebsocket() {
        try {
            String url = String.format("ws://localhost:%s/eyes", UniversalSdkNativeLoader.getPort());
            System.out.println("Resolved maxRedirects: " + System.getProperty("com.shaded.asynchttpclient.maxRedirects"));
            this.client = Dsl.asyncHttpClient(new DefaultAsyncHttpClientConfig.Builder().setWebSocketMaxFrameSize(0x10000000));
            return (WebSocket)this.client.prepareGet(url).execute(new WebSocketUpgradeHandler.Builder().addWebSocketListener(this.listener.getListener()).build()).get();
        }
        catch (Exception e) {
            throw new EyesException("Communication with server failed, reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized SyncTaskListener executeCommand(Command command) throws Exception {
        if (command instanceof EventDto) {
            this.webSocket.sendTextFrame(this.listener.objectMapper.writeValueAsString((Object)command));
            return null;
        }
        RequestDto request = (RequestDto)command;
        SyncTaskListener syncTaskListener = new SyncTaskListener(this.logger, request.getKey());
        this.listener.map.put(request.getKey(), syncTaskListener);
        String message = this.listener.objectMapper.writeValueAsString((Object)request);
        this.webSocket.sendTextFrame(message);
        return syncTaskListener;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to stop the HTTP Client!" + e.getMessage());
        }
    }
}

