/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal.mapper;

import com.applitools.eyes.universal.dto.AndroidDeviceInfoDto;
import com.applitools.eyes.universal.dto.AndroidDeviceRendererDto;
import com.applitools.eyes.universal.dto.ChromeEmulationDeviceRendererDto;
import com.applitools.eyes.universal.dto.ChromeEmulationInfoDto;
import com.applitools.eyes.universal.dto.DesktopBrowserRendererDto;
import com.applitools.eyes.universal.dto.IBrowsersInfo;
import com.applitools.eyes.universal.dto.IOSDeviceRendererDto;
import com.applitools.eyes.universal.dto.IosDeviceInfoDto;
import com.applitools.eyes.visualgrid.model.AndroidDeviceInfo;
import com.applitools.eyes.visualgrid.model.AndroidVersion;
import com.applitools.eyes.visualgrid.model.ChromeEmulationInfo;
import com.applitools.eyes.visualgrid.model.DeviceName;
import com.applitools.eyes.visualgrid.model.IosDeviceInfo;
import com.applitools.eyes.visualgrid.model.IosVersion;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;
import com.shaded.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.stream.Collectors;

public class RenderBrowserInfoMapper {
    public static IBrowsersInfo toRenderBrowserInfoDto(RenderBrowserInfo renderBrowserInfo) {
        if (renderBrowserInfo == null) {
            return null;
        }
        if (renderBrowserInfo.getEmulationInfo() instanceof ChromeEmulationInfo) {
            return RenderBrowserInfoMapper.getChromeEmulationDeviceRendererDto(renderBrowserInfo);
        }
        if (renderBrowserInfo.getIosDeviceInfo() != null) {
            return RenderBrowserInfoMapper.getIosDeviceRendererDto(renderBrowserInfo);
        }
        if (renderBrowserInfo.getAndroidDeviceInfo() != null) {
            return RenderBrowserInfoMapper.getAndroidDeviceRendererDto(renderBrowserInfo);
        }
        DesktopBrowserRendererDto desktopBrowserRendererDto = new DesktopBrowserRendererDto();
        desktopBrowserRendererDto.setName(renderBrowserInfo.getBrowserType().getName());
        desktopBrowserRendererDto.setHeight(renderBrowserInfo.getDeviceSize().getHeight());
        desktopBrowserRendererDto.setWidth(renderBrowserInfo.getDeviceSize().getWidth());
        return desktopBrowserRendererDto;
    }

    @NotNull
    private static ChromeEmulationDeviceRendererDto getChromeEmulationDeviceRendererDto(RenderBrowserInfo renderBrowserInfo) {
        ChromeEmulationInfo chromeEmulationInfo = (ChromeEmulationInfo)renderBrowserInfo.getEmulationInfo();
        ChromeEmulationDeviceRendererDto chromeRenderer = new ChromeEmulationDeviceRendererDto();
        ChromeEmulationInfoDto chromeEmulation = new ChromeEmulationInfoDto();
        chromeEmulation.setDeviceName(chromeEmulationInfo.getDeviceName());
        chromeEmulation.setScreenOrientation(chromeEmulationInfo.getScreenOrientation().getOrientation());
        chromeRenderer.setChromeEmulationInfo(chromeEmulation);
        return chromeRenderer;
    }

    @NotNull
    private static IOSDeviceRendererDto getIosDeviceRendererDto(RenderBrowserInfo renderBrowserInfo) {
        IosDeviceInfo iosDeviceInfo = renderBrowserInfo.getIosDeviceInfo();
        IOSDeviceRendererDto iosRenderer = new IOSDeviceRendererDto();
        IosDeviceInfoDto iosDevice = new IosDeviceInfoDto();
        iosDevice.setDeviceName(iosDeviceInfo.getDeviceName());
        iosDevice.setScreenOrientation(iosDeviceInfo.getScreenOrientation() == null ? null : iosDeviceInfo.getScreenOrientation().getOrientation());
        iosDevice.setVersion(iosDeviceInfo.getVersion() == null ? null : iosDeviceInfo.getVersion().getVersion());
        iosDevice.setVersion(renderBrowserInfo.getDeviceVersion() == null ? iosDevice.getVersion() : renderBrowserInfo.getDeviceVersion());
        iosRenderer.setIosDeviceInfo(iosDevice);
        return iosRenderer;
    }

    @NotNull
    private static AndroidDeviceRendererDto getAndroidDeviceRendererDto(RenderBrowserInfo renderBrowserInfo) {
        AndroidDeviceInfo androidDeviceInfo = renderBrowserInfo.getAndroidDeviceInfo();
        AndroidDeviceRendererDto androidRenderer = new AndroidDeviceRendererDto();
        AndroidDeviceInfoDto androidDevice = new AndroidDeviceInfoDto();
        androidDevice.setDeviceName(androidDeviceInfo.getDeviceName());
        androidDevice.setScreenOrientation(androidDeviceInfo.getScreenOrientation() == null ? null : androidDeviceInfo.getScreenOrientation().getOrientation());
        androidDevice.setVersion(androidDeviceInfo.getVersion() == null ? null : androidDeviceInfo.getVersion().getVersion());
        androidDevice.setVersion(renderBrowserInfo.getDeviceVersion() == null ? androidDevice.getVersion() : renderBrowserInfo.getDeviceVersion());
        androidRenderer.setAndroidDeviceInfo(androidDevice);
        return androidRenderer;
    }

    public static List<IBrowsersInfo> toRenderBrowserInfoDtoList(List<RenderBrowserInfo> renderBrowserInfos) {
        if (renderBrowserInfos == null || renderBrowserInfos.isEmpty()) {
            return null;
        }
        return renderBrowserInfos.stream().map(RenderBrowserInfoMapper::toRenderBrowserInfoDto).collect(Collectors.toList());
    }

    public static ChromeEmulationInfo toEmulationInfo(ChromeEmulationInfoDto dto) {
        if (dto == null) {
            return null;
        }
        DeviceName deviceName = DeviceName.fromName((String)dto.getDeviceName());
        ScreenOrientation screenOrientation = ScreenOrientation.fromOrientation((String)dto.getScreenOrientation());
        return new ChromeEmulationInfo(deviceName, screenOrientation);
    }

    public static IosDeviceInfo toIosDeviceInfo(IosDeviceInfoDto dto) {
        if (dto == null) {
            return null;
        }
        String iosDeviceName = dto.getDeviceName();
        ScreenOrientation screenOrientation = ScreenOrientation.fromOrientation((String)dto.getScreenOrientation());
        IosVersion iosVersion = IosVersion.fromVersion((String)dto.getVersion());
        return new IosDeviceInfo(iosDeviceName, screenOrientation, iosVersion);
    }

    public static AndroidDeviceInfo toAndroidDeviceInfo(AndroidDeviceInfoDto dto) {
        if (dto == null) {
            return null;
        }
        String androidDeviceName = dto.getDeviceName();
        ScreenOrientation screenOrientation = ScreenOrientation.fromOrientation((String)dto.getScreenOrientation());
        AndroidVersion androidVersion = AndroidVersion.fromVersion((String)dto.getVersion());
        return new AndroidDeviceInfo(androidDeviceName, screenOrientation, androidVersion);
    }
}

