/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.HttpResponseBodyPart;
import com.shaded.asynchttpclient.HttpResponseStatus;
import com.shaded.asynchttpclient.Response;
import com.shaded.asynchttpclient.handler.ProgressAsyncHandler;
import com.shaded.jetbrains.annotations.Nullable;
import com.shaded.netty.handler.codec.http.HttpHeaders;
import com.shaded.slf4j.Logger;
import com.shaded.slf4j.LoggerFactory;

public abstract class AsyncCompletionHandler<T>
implements ProgressAsyncHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCompletionHandler.class);
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.builder.reset();
        this.builder.accumulate(status);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        this.builder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.builder.accumulate(content);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        this.builder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    @Nullable
    public final T onCompleted() throws Exception {
        return this.onCompleted(this.builder.build());
    }

    @Override
    public void onThrowable(Throwable t) {
        LOGGER.debug(t.getMessage(), t);
    }

    @Nullable
    public abstract T onCompleted(@Nullable Response var1) throws Exception;

    @Override
    public AsyncHandler.State onHeadersWritten() {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWritten() {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
        return AsyncHandler.State.CONTINUE;
    }
}

