/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient;

import com.shaded.asynchttpclient.AsyncCompletionHandlerBase;
import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.AsyncHttpClient;
import com.shaded.asynchttpclient.AsyncHttpClientConfig;
import com.shaded.asynchttpclient.AsyncHttpClientState;
import com.shaded.asynchttpclient.BoundRequestBuilder;
import com.shaded.asynchttpclient.ClientStats;
import com.shaded.asynchttpclient.DefaultAsyncHttpClientConfig;
import com.shaded.asynchttpclient.ListenableFuture;
import com.shaded.asynchttpclient.Request;
import com.shaded.asynchttpclient.RequestBuilder;
import com.shaded.asynchttpclient.Response;
import com.shaded.asynchttpclient.SignatureCalculator;
import com.shaded.asynchttpclient.channel.ChannelPool;
import com.shaded.asynchttpclient.cookie.CookieEvictionTask;
import com.shaded.asynchttpclient.cookie.CookieStore;
import com.shaded.asynchttpclient.exception.FilterException;
import com.shaded.asynchttpclient.filter.FilterContext;
import com.shaded.asynchttpclient.filter.RequestFilter;
import com.shaded.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import com.shaded.asynchttpclient.netty.channel.ChannelManager;
import com.shaded.asynchttpclient.netty.request.NettyRequestSender;
import com.shaded.asynchttpclient.util.HttpConstants;
import com.shaded.jetbrains.annotations.Nullable;
import com.shaded.netty.channel.EventLoopGroup;
import com.shaded.netty.handler.codec.http.cookie.Cookie;
import com.shaded.netty.util.HashedWheelTimer;
import com.shaded.netty.util.Timer;
import com.shaded.netty.util.concurrent.DefaultThreadFactory;
import com.shaded.slf4j.Logger;
import com.shaded.slf4j.LoggerFactory;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

public class DefaultAsyncHttpClient
implements AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClient.class);
    private final AsyncHttpClientConfig config;
    private final boolean noRequestFilters;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    @Nullable
    private SignatureCalculator signatureCalculator;

    public DefaultAsyncHttpClient() {
        this(new DefaultAsyncHttpClientConfig.Builder().build());
    }

    public DefaultAsyncHttpClient(AsyncHttpClientConfig config) {
        this.config = config;
        this.noRequestFilters = config.getRequestFilters().isEmpty();
        Timer configTimer = config.getNettyTimer();
        if (configTimer == null) {
            this.allowStopNettyTimer = true;
            this.nettyTimer = DefaultAsyncHttpClient.newNettyTimer(config);
        } else {
            this.allowStopNettyTimer = false;
            this.nettyTimer = configTimer;
        }
        this.channelManager = new ChannelManager(config, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.channelManager, this.nettyTimer, new AsyncHttpClientState(this.closed));
        this.channelManager.configureBootstraps(this.requestSender);
        CookieStore cookieStore = config.getCookieStore();
        if (cookieStore != null) {
            int cookieStoreCount = config.getCookieStore().incrementAndGet();
            if (this.allowStopNettyTimer || cookieStoreCount == 1) {
                this.nettyTimer.newTimeout(new CookieEvictionTask(config.expiredCookieEvictionDelay(), cookieStore), config.expiredCookieEvictionDelay(), TimeUnit.MILLISECONDS);
            }
        }
    }

    ChannelManager channelManager() {
        return this.channelManager;
    }

    private static Timer newNettyTimer(AsyncHttpClientConfig config) {
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName() + "-timer");
        HashedWheelTimer timer = new HashedWheelTimer(threadFactory, config.getHashedWheelTimerTickDuration(), TimeUnit.MILLISECONDS, config.getHashedWheelTimerSize());
        timer.start();
        return timer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on ChannelManager close", t);
            }
            CookieStore cookieStore = this.config.getCookieStore();
            if (cookieStore != null) {
                cookieStore.decrementAndGet();
            }
            if (this.allowStopNettyTimer) {
                try {
                    this.nettyTimer.stop();
                }
                catch (Throwable t) {
                    LOGGER.warn("Unexpected error on HashedWheelTimer close", t);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DefaultAsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    @Override
    public BoundRequestBuilder prepare(String method, String url) {
        return this.requestBuilder(method, url);
    }

    @Override
    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder(HttpConstants.Methods.GET, url);
    }

    @Override
    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder(HttpConstants.Methods.CONNECT, url);
    }

    @Override
    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder(HttpConstants.Methods.OPTIONS, url);
    }

    @Override
    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder(HttpConstants.Methods.HEAD, url);
    }

    @Override
    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder(HttpConstants.Methods.POST, url);
    }

    @Override
    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder(HttpConstants.Methods.PUT, url);
    }

    @Override
    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder(HttpConstants.Methods.DELETE, url);
    }

    @Override
    public BoundRequestBuilder preparePatch(String url) {
        return this.requestBuilder(HttpConstants.Methods.PATCH, url);
    }

    @Override
    public BoundRequestBuilder prepareTrace(String url) {
        return this.requestBuilder(HttpConstants.Methods.TRACE, url);
    }

    @Override
    public BoundRequestBuilder prepareRequest(Request request) {
        return this.requestBuilder(request);
    }

    @Override
    public BoundRequestBuilder prepareRequest(RequestBuilder requestBuilder) {
        return this.prepareRequest(requestBuilder.build());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) {
        if (this.config.getCookieStore() != null) {
            try {
                List<Cookie> cookies = this.config.getCookieStore().get(request.getUri());
                if (!cookies.isEmpty()) {
                    RequestBuilder requestBuilder = request.toBuilder();
                    for (Cookie cookie : cookies) {
                        requestBuilder.addCookieIfUnset(cookie);
                    }
                    request = requestBuilder.build();
                }
            }
            catch (Exception e) {
                handler.onThrowable(e);
                return new ListenableFuture.CompletedFailure("Failed to set cookies of request", e);
            }
        }
        if (this.noRequestFilters) {
            return this.execute(request, handler);
        }
        FilterContext<T> fc = new FilterContext.FilterContextBuilder<T>(handler, request).build();
        try {
            fc = this.preProcessRequest(fc);
        }
        catch (Exception e) {
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure("preProcessRequest failed", e);
        }
        return this.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, AsyncHandler<T> handler) {
        return this.executeRequest(requestBuilder.build(), handler);
    }

    @Override
    public ListenableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, new AsyncCompletionHandlerBase());
    }

    @Override
    public ListenableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return this.executeRequest(requestBuilder.build());
    }

    private <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) {
        try {
            return this.requestSender.sendRequest(request, asyncHandler, null);
        }
        catch (Exception e) {
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
    }

    private <T> FilterContext<T> preProcessRequest(FilterContext<T> fc) throws FilterException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            fc = asyncFilter.filter(fc);
            Objects.requireNonNull(fc, "filterContext");
        }
        Request request = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)fc.getAsyncHandler()).adjustRequestRange(request);
        }
        if (request.getRangeOffset() != 0L) {
            RequestBuilder builder = request.toBuilder();
            builder.setHeader((CharSequence)"Range", "bytes=" + request.getRangeOffset() + "-");
            request = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder<T>(fc).request(request).build();
        return fc;
    }

    public ChannelPool getChannelPool() {
        return this.channelManager.getChannelPool();
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.channelManager.getEventLoopGroup();
    }

    @Override
    public ClientStats getClientStats() {
        return this.channelManager.getClientStats();
    }

    @Override
    public void flushChannelPoolPartitions(Predicate<Object> predicate) {
        this.getChannelPool().flushPartitions(predicate);
    }

    protected BoundRequestBuilder requestBuilder(String method, String url) {
        return (BoundRequestBuilder)((BoundRequestBuilder)new BoundRequestBuilder(this, method, this.config.isDisableUrlEncodingForBoundRequests()).setUrl(url)).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return (BoundRequestBuilder)new BoundRequestBuilder(this, prototype).setSignatureCalculator(this.signatureCalculator);
    }

    @Override
    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }
}

