/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.netty.handler.intercept;

import com.shaded.asynchttpclient.Request;
import com.shaded.asynchttpclient.netty.NettyResponseFuture;
import com.shaded.asynchttpclient.netty.channel.ChannelManager;
import com.shaded.asynchttpclient.netty.request.NettyRequestSender;
import com.shaded.asynchttpclient.proxy.ProxyServer;
import com.shaded.asynchttpclient.uri.Uri;
import com.shaded.netty.channel.Channel;
import com.shaded.netty.util.concurrent.Future;
import com.shaded.slf4j.Logger;
import com.shaded.slf4j.LoggerFactory;

public class ConnectSuccessInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectSuccessInterceptor.class);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;

    ConnectSuccessInterceptor(ChannelManager channelManager, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.requestSender = requestSender;
    }

    public boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer) {
        if (future.isKeepAlive()) {
            future.attachChannel(channel, true);
        }
        Uri requestUri = request.getUri();
        LOGGER.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)requestUri.getScheme());
        Future<Channel> whenHandshaked = this.channelManager.updatePipelineForHttpTunneling(channel.pipeline(), requestUri);
        future.setReuseChannel(true);
        future.setConnectAllowed(false);
        Request targetRequest = future.getTargetRequest().toBuilder().build();
        if (whenHandshaked == null) {
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, targetRequest);
        } else {
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, targetRequest, whenHandshaked);
        }
        return true;
    }
}

