/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.request.body.multipart.part;

import com.shaded.asynchttpclient.request.body.multipart.StringPart;
import com.shaded.asynchttpclient.request.body.multipart.part.MultipartPart;
import com.shaded.asynchttpclient.request.body.multipart.part.MultipartState;
import com.shaded.netty.buffer.ByteBuf;
import com.shaded.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class StringMultipartPart
extends MultipartPart<StringPart> {
    private final ByteBuf contentBuffer;

    public StringMultipartPart(StringPart part, byte[] boundary) {
        super(part, boundary);
        this.contentBuffer = Unpooled.wrappedBuffer(part.getValue().getBytes(part.getCharset()));
    }

    @Override
    protected long getContentLength() {
        return this.contentBuffer.capacity();
    }

    @Override
    protected long transferContentTo(ByteBuf target) {
        return this.transfer(this.contentBuffer, target, MultipartState.POST_CONTENT);
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        return this.transfer(this.contentBuffer, target, MultipartState.POST_CONTENT);
    }

    @Override
    public void close() {
        super.close();
        this.contentBuffer.release();
    }
}

