/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.resolver;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.netty.SimpleFutureListener;
import com.shaded.netty.resolver.NameResolver;
import com.shaded.netty.util.concurrent.Future;
import com.shaded.netty.util.concurrent.GenericFutureListener;
import com.shaded.netty.util.concurrent.ImmediateEventExecutor;
import com.shaded.netty.util.concurrent.Promise;
import com.shaded.slf4j.Logger;
import com.shaded.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public enum RequestHostnameResolver {
    INSTANCE;

    private static final Logger LOGGER;

    public Future<List<InetSocketAddress>> resolve(NameResolver<InetAddress> nameResolver, InetSocketAddress unresolvedAddress, final AsyncHandler<?> asyncHandler) {
        final String hostname = unresolvedAddress.getHostString();
        final int port = unresolvedAddress.getPort();
        final Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        try {
            asyncHandler.onHostnameResolutionAttempt(hostname);
        }
        catch (Exception e) {
            LOGGER.error("onHostnameResolutionAttempt crashed", e);
            promise.tryFailure(e);
            return promise;
        }
        Future<List<InetAddress>> whenResolved = nameResolver.resolveAll(hostname);
        whenResolved.addListener((GenericFutureListener<Future<List<InetAddress>>>)new SimpleFutureListener<List<InetAddress>>(){

            @Override
            protected void onSuccess(List<InetAddress> value) {
                ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(value.size());
                for (InetAddress a : value) {
                    socketAddresses.add(new InetSocketAddress(a, port));
                }
                try {
                    asyncHandler.onHostnameResolutionSuccess(hostname, socketAddresses);
                }
                catch (Exception e) {
                    LOGGER.error("onHostnameResolutionSuccess crashed", e);
                    promise.tryFailure(e);
                    return;
                }
                promise.trySuccess(socketAddresses);
            }

            @Override
            protected void onFailure(Throwable t) {
                try {
                    asyncHandler.onHostnameResolutionFailure(hostname, t);
                }
                catch (Exception e) {
                    LOGGER.error("onHostnameResolutionFailure crashed", e);
                    promise.tryFailure(e);
                    return;
                }
                promise.tryFailure(t);
            }
        });
        return promise;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RequestHostnameResolver.class);
    }
}

