/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.ws;

import com.shaded.asynchttpclient.util.MessageDigestUtils;
import com.shaded.netty.util.internal.ThreadLocalRandom;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class WebSocketUtils {
    private static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    private WebSocketUtils() {
    }

    public static String getWebSocketKey() {
        byte[] nonce = new byte[16];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < nonce.length; ++i) {
            nonce[i] = (byte)random.nextInt(256);
        }
        return Base64.getEncoder().encodeToString(nonce);
    }

    public static String getAcceptKey(String key) {
        return Base64.getEncoder().encodeToString(MessageDigestUtils.pooledSha1MessageDigest().digest((key + MAGIC_GUID).getBytes(StandardCharsets.US_ASCII)));
    }
}

