/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.locators;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.locators.VisualLocatorsData;
import com.applitools.eyes.locators.VisualLocatorsProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class BaseVisualLocatorsProvider
implements VisualLocatorsProvider {
    protected Logger logger;
    private final ServerConnector serverConnector;
    protected double devicePixelRatio;
    protected String appName;
    protected DebugScreenshotsProvider debugScreenshotsProvider;

    public BaseVisualLocatorsProvider(Logger logger, ServerConnector serverConnector, double devicePixelRatio, String appName, DebugScreenshotsProvider debugScreenshotsProvider) {
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.devicePixelRatio = devicePixelRatio;
        this.appName = appName;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
    }

    public Map<String, List<Region>> getLocators(VisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        this.logger.verbose("Get locators with given names: " + visualLocatorSettings.getNames());
        this.logger.verbose("Requested viewport screenshot for visual locators...");
        BufferedImage viewPortScreenshot = this.getViewPortScreenshot();
        this.debugScreenshotsProvider.save(viewPortScreenshot, "Visual locators: " + Arrays.toString(visualLocatorSettings.getNames().toArray()));
        this.logger.verbose("Convert screenshot from BufferedImage to base64...");
        byte[] image = ImageUtils.encodeAsPng((BufferedImage)viewPortScreenshot);
        this.logger.verbose("Post visual locators screenshot...");
        String viewportScreenshotUrl = this.serverConnector.postViewportImage(image);
        this.logger.verbose("Screenshot URL: " + viewportScreenshotUrl);
        VisualLocatorsData data = new VisualLocatorsData(this.appName, viewportScreenshotUrl, visualLocatorSettings.isFirstOnly(), visualLocatorSettings.getNames());
        this.logger.verbose("Post visual locators: " + data.toString());
        return this.serverConnector.postLocators(data);
    }

    protected abstract BufferedImage getViewPortScreenshot();
}

