/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.locators;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.locators.VisualLocatorsData;
import com.applitools.eyes.locators.VisualLocatorsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class BaseVisualLocatorsProvider
implements VisualLocatorsProvider {
    protected Logger logger;
    protected final String testId;
    private final ServerConnector serverConnector;
    private final ScreenshotProvider screenshotProvider;
    protected double devicePixelRatio;
    protected String appName;
    protected DebugScreenshotsProvider debugScreenshotsProvider;

    public BaseVisualLocatorsProvider(Logger logger, String testId, ServerConnector serverConnector, ScreenshotProvider screenshotProvider, double devicePixelRatio, String appName, DebugScreenshotsProvider debugScreenshotsProvider) {
        this.logger = logger;
        this.testId = testId;
        this.serverConnector = serverConnector;
        this.screenshotProvider = screenshotProvider;
        this.devicePixelRatio = devicePixelRatio;
        this.appName = appName;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
    }

    public Map<String, List<Region>> getLocators(VisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        BufferedImage viewPortScreenshot = this.screenshotProvider.getViewPortScreenshot(Stage.LOCATE);
        this.logger.log(this.testId, Stage.LOCATE, new Pair[]{Pair.of((Object)"locatorNames", (Object)visualLocatorSettings.getNames()), Pair.of((Object)"devicePixelRatio", (Object)this.devicePixelRatio), Pair.of((Object)"scaledImageSize", (Object)new RectangleSize(viewPortScreenshot.getWidth(), viewPortScreenshot.getHeight()))});
        this.debugScreenshotsProvider.save(viewPortScreenshot, "visual_locators_final");
        byte[] image = ImageUtils.encodeAsPng((BufferedImage)viewPortScreenshot);
        SyncTaskListener listener = new SyncTaskListener(this.logger, "getLocators");
        this.serverConnector.uploadImage((TaskListener)listener, image);
        String viewportScreenshotUrl = (String)listener.get();
        if (viewportScreenshotUrl == null) {
            throw new EyesException("Failed posting viewport image");
        }
        VisualLocatorsData data = new VisualLocatorsData(this.appName, viewportScreenshotUrl, visualLocatorSettings.isFirstOnly(), visualLocatorSettings.getNames());
        this.logger.log(this.testId, Stage.LOCATE, new Pair[]{Pair.of((Object)"screenshotUrl", (Object)viewportScreenshotUrl), Pair.of((Object)"visualLocatorsData", (Object)data)});
        SyncTaskListener postListener = new SyncTaskListener(this.logger, "getLocators");
        this.serverConnector.postLocators((TaskListener)postListener, data);
        Map result = (Map)postListener.get();
        if (result == null) {
            throw new EyesException("Failed posting locators");
        }
        this.logger.log(this.testId, Stage.LOCATE, new Pair[]{Pair.of((Object)"result", (Object)result)});
        return result;
    }
}

