/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Padding;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.ImplicitInitiation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.serializers.WebElementSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class SimpleRegionByElement
implements GetSimpleRegion,
IGetSeleniumRegion,
ImplicitInitiation {
    @JsonIgnore
    private EyesWebDriver driver;
    @JsonSerialize(using=WebElementSerializer.class)
    protected final WebElement element;
    @JsonIgnore
    protected final Padding padding;
    private String regionId;

    public SimpleRegionByElement(WebElement element) {
        this(element, new Padding());
    }

    public SimpleRegionByElement(WebElement element, Padding padding) {
        this.element = element;
        this.padding = padding;
    }

    @Override
    public void init(Logger logger, EyesWebDriver driver) {
        this.driver = driver;
    }

    public List<Region> getRegions(EyesScreenshot screenshot) {
        Rectangle rectangle = EyesDriverUtils.getVisibleElementRect(this.element, this.driver);
        Dimension size = this.element.getSize();
        Location adjustedLocation = new Location(rectangle.x, rectangle.y);
        if (screenshot != null) {
            adjustedLocation = screenshot.convertLocation(adjustedLocation, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        }
        ArrayList<Region> value = new ArrayList<Region>();
        Region region = new Region(adjustedLocation, new RectangleSize(size.width, size.height), CoordinatesType.SCREENSHOT_AS_IS);
        region = region.addPadding(this.padding);
        value.add(region);
        return value;
    }

    @JsonProperty(value="element")
    public WebElement getElement() {
        return this.element;
    }

    @Override
    public List<WebElement> getElements() {
        return Collections.singletonList(this.element);
    }

    public SimpleRegionByElement regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Padding getPadding() {
        return this.padding;
    }
}

