/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.MouseTrigger;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.Point;
import org.openqa.selenium.interactions.internal.Coordinates;

class EyesMouse
implements Mouse {
    private EyesWebDriver eyesDriver;
    private Mouse mouse;
    private Location mouseLocation;

    public EyesMouse(EyesWebDriver eyesDriver, Mouse mouse) {
        ArgumentGuard.notNull(eyesDriver, "eyesDriver");
        ArgumentGuard.notNull(mouse, "mouse");
        this.eyesDriver = eyesDriver;
        this.mouse = mouse;
        this.mouseLocation = new Location(0, 0);
    }

    protected void moveIfNeeded(Coordinates where) {
        if (where != null) {
            this.mouseMove(where);
        }
    }

    public void click(Coordinates where) {
        Location location = EyesMouse.location(where);
        Logger.verbose("click(" + location + ")");
        this.moveIfNeeded(where);
        MouseTrigger trigger = new MouseTrigger(MouseAction.Click, this.getFakeControl(), this.mouseLocation);
        this.eyesDriver.addUserInput(trigger);
        Logger.verbose("click(): Location is " + this.mouseLocation);
        this.mouse.click(where);
    }

    public void doubleClick(Coordinates where) {
        Location location = EyesMouse.location(where);
        Logger.verbose("doubleClick(" + location + ")");
        this.moveIfNeeded(where);
        MouseTrigger trigger = new MouseTrigger(MouseAction.DoubleClick, this.getFakeControl(), this.mouseLocation);
        this.eyesDriver.addUserInput(trigger);
        Logger.verbose("doubleClick(): Location is " + this.mouseLocation);
        this.mouse.doubleClick(where);
    }

    public void mouseDown(Coordinates where) {
        Location location = EyesMouse.location(where);
        Logger.verbose("mouseDown(" + location + ")");
        this.moveIfNeeded(where);
        MouseTrigger trigger = new MouseTrigger(MouseAction.Down, this.getFakeControl(), this.mouseLocation);
        this.eyesDriver.addUserInput(trigger);
        Logger.verbose("mouseDown(): Location is " + this.mouseLocation);
        this.mouse.mouseDown(where);
    }

    public void mouseUp(Coordinates where) {
        Location location = EyesMouse.location(where);
        Logger.verbose("mouseUp(" + location + ")");
        this.moveIfNeeded(where);
        MouseTrigger trigger = new MouseTrigger(MouseAction.Up, this.getFakeControl(), this.mouseLocation);
        this.eyesDriver.addUserInput(trigger);
        Logger.verbose("mouseUp(): Location is " + this.mouseLocation);
        this.mouse.mouseUp(where);
    }

    public void mouseMove(Coordinates where) {
        Location location = EyesMouse.location(where);
        Logger.verbose("mouseMove(" + location + ")");
        if (location != null) {
            int newX = Math.max(0, location.getX());
            int newY = Math.max(0, location.getY());
            this.mouseLocation = new Location(newX, newY);
            MouseTrigger trigger = new MouseTrigger(MouseAction.Move, this.getFakeControl(), this.mouseLocation);
            this.eyesDriver.addUserInput(trigger);
        }
        this.mouse.mouseMove(where);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        int newY;
        int newX;
        Location location = EyesMouse.location(where);
        Logger.verbose("mouseMove(" + location + ", " + xOffset + ", " + yOffset + ")");
        if (location != null) {
            newX = (int)((long)location.getX() + xOffset);
            newY = (int)((long)location.getY() + yOffset);
        } else {
            newX = (int)((long)this.mouseLocation.getX() + xOffset);
            newY = (int)((long)this.mouseLocation.getY() + yOffset);
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        this.mouseLocation = new Location(newX, newY);
        MouseTrigger trigger = new MouseTrigger(MouseAction.Move, this.getFakeControl(), this.mouseLocation);
        this.eyesDriver.addUserInput(trigger);
        this.mouse.mouseMove(where, xOffset, yOffset);
    }

    public void contextClick(Coordinates where) {
        Location location = EyesMouse.location(where);
        Logger.verbose("contextClick(" + location + ")");
        this.moveIfNeeded(where);
        MouseTrigger trigger = new MouseTrigger(MouseAction.RightClick, this.getFakeControl(), this.mouseLocation);
        this.eyesDriver.addUserInput(trigger);
        Logger.verbose("contextClick(): Location is " + this.mouseLocation);
        this.mouse.contextClick(where);
    }

    private Region getFakeControl() {
        return new Region(0, 0, this.mouseLocation.getX(), this.mouseLocation.getY());
    }

    private static Location location(Coordinates where) {
        if (where == null) {
            return null;
        }
        Point p = where.onPage();
        return new Location(p.getX(), p.getY());
    }
}

