/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NewTestException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TargetWebDriverApplication;
import com.applitools.eyes.TestFailedException;
import com.applitools.eyes.TestResults;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.net.URI;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes {
    private static final int DEFAULT_MATCH_TIMEOUT = 2;
    private static final MatchLevel DEFAULT_MATCH_LEVEL = MatchLevel.EXACT;
    private static final String GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_NORMAL_BROWSER = "return window.innerHeight";
    private static final String GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_NORMAL_BROWSER = "return window.innerWidth";
    private static final String DOCUMENT_CLEAR_SCROLL_BARS_JAVASCRIPT = "var doc = document.documentElement;var previousOverflow = doc.style.overflow;";
    private static final String DOCUMENT_RESET_SCROLL_BARS_JAVASCRIPT = "doc.style.overflow = previousOverflow;";
    private static final String DOCUMENT_RETURN_JAVASCRIPT = "return __applitools_result;";
    private static final String GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_BAD_BROWSERS = "var doc = document.documentElement;var previousOverflow = doc.style.overflow;var __applitools_result = doc.clientWidth;doc.style.overflow = previousOverflow;return __applitools_result;";
    private static final String GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_BAD_BROWSERS = "var doc = document.documentElement;var previousOverflow = doc.style.overflow;var __applitools_result = doc.clientHeight;doc.style.overflow = previousOverflow;return __applitools_result;";
    private EyesWebDriver driver;
    private AgentConnector agentConnector;
    private FailureReports failureReports;
    private RunningSession runningSession;
    private MatchWindowTask matchWindowTask;
    private SessionStartInfo sessionStartInfo;
    private int matchTimeout;
    private boolean isOpen;
    private String appName;
    private String testName;
    private MatchLevel matchLevel;
    private RectangleSize viewportSize;
    private BatchInfo batch;
    private String hostApp;
    private String hostOS;
    private String branchName;
    private String parentBranchName;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private boolean isDisabled;

    public Eyes(URI serverUrl, boolean isDisabled) {
        if (isDisabled) {
            this.isDisabled = true;
            Logger.verbose("Eyes(): Ignored");
            return;
        }
        ArgumentGuard.notNull(serverUrl, "serverUrl");
        Logger.log("Eyes Server URL is " + serverUrl);
        this.viewportSize = null;
        this.agentConnector = new AgentConnector(serverUrl);
        this.matchTimeout = 2;
        this.runningSession = null;
        this.failureReports = FailureReports.ON_CLOSE;
    }

    public Eyes(URI serverUrl) {
        this(serverUrl, false);
    }

    public static void setLogHandler(LogHandler logHandler) {
        Logger.setLogHandler(logHandler);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel, FailureReports failureReports) {
        if (this.isDisabled) {
            Logger.verbose("open(): Ignored");
            return driver;
        }
        ArgumentGuard.notNull(driver, "driver");
        ArgumentGuard.notNull(appName, "appName");
        ArgumentGuard.notNull(testName, "testName");
        ArgumentGuard.notEqual((Object)matchLevel, (Object)MatchLevel.NONE, "matchLevel");
        Logger.verbose("open(" + appName + ", " + testName + ", " + viewportSize + ", " + (Object)((Object)failureReports) + ")");
        if (this.isOpen) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            Logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver((RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            Logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        this.appName = appName;
        this.testName = testName;
        this.viewportSize = viewportSize;
        this.matchLevel = matchLevel;
        this.failureReports = failureReports;
        this.isOpen = true;
        return this.driver;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel) {
        return this.open(driver, appName, testName, viewportSize, matchLevel, FailureReports.ON_CLOSE);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, FailureReports failureReports) {
        return this.open(driver, appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, failureReports);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        return this.open(driver, appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, null, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    public void checkWindow(String tag) {
        MatchResult result;
        if (this.isDisabled) {
            Logger.verbose("checkWindow(): Ignored");
            return;
        }
        Logger.verbose("checkWindow(" + (tag == null ? "" : tag) + ")");
        ArgumentGuard.isValidState(this.isOpen, "Eyes not open");
        if (this.runningSession == null) {
            this.startSession();
            this.matchWindowTask = new MatchWindowTask(this.agentConnector, this.runningSession, this.driver, this.matchTimeout);
        }
        if (!(result = this.matchWindowTask.matchWindow(tag, this.shouldMatchWindowRunOnceOnTimeout)).getAsExpected()) {
            this.shouldMatchWindowRunOnceOnTimeout = true;
            if (!this.runningSession.getIsNewSession()) {
                Logger.log("Mismatch!" + (tag == null ? "" : " (" + tag + ")"));
            }
            if (this.failureReports.equals((Object)FailureReports.IMMEDIATE)) {
                throw new TestFailedException("Mismatch found in '" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'");
            }
        }
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public TestResults close() {
        if (this.isDisabled) {
            Logger.verbose("close(): Ignored");
            return null;
        }
        Logger.verbose("close()");
        ArgumentGuard.isValidState(this.isOpen, "Eyes not open");
        this.isOpen = false;
        if (this.runningSession == null) {
            Logger.verbose("close(): Server session was not started");
            Logger.log("--- Empty test ended.");
            return new TestResults();
        }
        boolean isNewSession = this.runningSession.getIsNewSession();
        String sessionResultsUrl = this.runningSession.getUrl();
        Logger.verbose("close(): Ending server session...");
        TestResults results = this.agentConnector.stopSession(this.runningSession, false);
        Logger.verbose("close(): " + results);
        this.runningSession = null;
        if (!(isNewSession || 0 >= results.getMismatches() && 0 >= results.getMissing())) {
            Logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
            String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. See details at " + sessionResultsUrl;
            throw new TestFailedException(results, message);
        }
        if (isNewSession) {
            String instructions = "Please approve the new baseline at " + sessionResultsUrl;
            Logger.log("--- New test ended. " + instructions);
            String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
            throw new NewTestException(results, message);
        }
        Logger.log("--- Test passed. See details at " + sessionResultsUrl);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortIfNotClosed() {
        if (this.isDisabled) {
            Logger.verbose("abortIfNotClosed(): Ignored");
            return;
        }
        this.isOpen = false;
        if (null == this.runningSession) {
            Logger.verbose("abortIfNotClosed(): closed");
            return;
        }
        Logger.verbose("abortIfNotClosed(): Aborting server session...");
        try {
            this.agentConnector.stopSession(this.runningSession, true);
            Logger.log("--- Test aborted.");
        }
        catch (EyesException ex) {
            Logger.log("Failed to abort server session: " + ex.getMessage());
        }
        finally {
            this.runningSession = null;
        }
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public void setParentBranchName(String branchName) {
        this.parentBranchName = branchName;
    }

    public void setMatchTimeout(int seconds) {
        if (this.isDisabled) {
            Logger.verbose("setMatchTimeout(): Ignored");
            return;
        }
        Logger.verbose("setMatchTimeout(" + seconds + ")");
        ArgumentGuard.greaterThanOrEqualToZero(seconds, "seconds");
        this.matchTimeout = seconds;
        Logger.log("Match timeout set to " + seconds + " second(s)");
    }

    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.isDisabled) {
            Logger.verbose("setAppEnvironment(): Ignored");
            return;
        }
        Logger.verbose("setAppEnvironment(" + hostOS + ", " + hostApp + ")");
        this.hostOS = hostOS;
        this.hostApp = hostApp;
    }

    public void setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            Logger.verbose("setBatch(): Ignored");
            return;
        }
        ArgumentGuard.isValidState(null == this.runningSession, "test is running");
        Logger.verbose("setBatch(" + batch + ")");
        this.batch = batch;
    }

    private Dimension getViewportSize() {
        try {
            int width = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_NORMAL_BROWSER, new Object[0]).toString());
            int height = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_NORMAL_BROWSER, new Object[0]).toString());
            return new Dimension(width, height);
        }
        catch (NumberFormatException ex) {
            Logger.verbose("getViewportSize(): Browser does not support innerWidth/Height (" + ex.getMessage() + ")");
            try {
                int width = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_BAD_BROWSERS, new Object[0]).toString());
                int height = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_BAD_BROWSERS, new Object[0]).toString());
                return new Dimension(width, height);
            }
            catch (Exception ex2) {
                Logger.verbose("getViewportSize(): only window size is available (" + ex2.getMessage() + ")");
                return this.driver.manage().window().getSize();
            }
        }
    }

    private void setViewportSize(RectangleSize size) {
        Dimension browserSize;
        Logger.verbose("setViewportSize(" + size + ")");
        int SLEEP = 1000;
        int RETRIES = 3;
        Dimension requiredSize = new Dimension(size.getWidth(), size.getHeight());
        this.driver.manage().window().setSize(requiredSize);
        int retriesLeft = 3;
        do {
            GeneralUtils.sleep(1000L);
            browserSize = this.driver.manage().window().getSize();
        } while (--retriesLeft > 0 && !browserSize.equals((Object)requiredSize));
        if (!browserSize.equals((Object)requiredSize)) {
            String errMsg = "Failed to set browser size";
            Logger.log(errMsg);
            throw new TestFailedException(errMsg);
        }
        Dimension viewportSize = this.getViewportSize();
        Logger.verbose("setViewportSize(): initial size is " + viewportSize);
        this.driver.manage().window().setSize(new Dimension(2 * browserSize.width - viewportSize.width, 2 * browserSize.height - viewportSize.height));
        retriesLeft = 3;
        do {
            GeneralUtils.sleep(1000L);
            viewportSize = this.getViewportSize();
            Logger.verbose("setViewportSize(): size is " + viewportSize);
        } while (--retriesLeft > 0 && !viewportSize.equals((Object)requiredSize));
        if (!viewportSize.equals((Object)requiredSize)) {
            String errMsg = "Failed to set browser's viewport size";
            Logger.log(errMsg);
            throw new TestFailedException(errMsg);
        }
        this.viewportSize = size;
    }

    private AppEnvironment getEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.hostOS != null) {
            appEnv.setOs(this.hostOS);
        }
        if (this.hostApp != null) {
            appEnv.setHostingApp(this.hostApp);
        }
        appEnv.setDisplaySize(this.viewportSize);
        return appEnv;
    }

    private void startSession() {
        BatchInfo testBatch;
        Logger.verbose("startSession()");
        if (this.viewportSize == null) {
            this.viewportSize = new RectangleSize(this.getViewportSize());
        } else {
            this.setViewportSize(this.viewportSize);
        }
        if (this.batch == null) {
            Logger.verbose("startSession(): No batch set");
            testBatch = new BatchInfo(null);
        } else {
            Logger.verbose("startSession(): Batch is " + this.batch);
            testBatch = this.batch;
        }
        AppEnvironment appEnv = this.getEnvironment();
        Logger.verbose("startSession(): Application environment is " + appEnv);
        TargetWebDriverApplication application = this.driver.GetTargetWebDriverApplication();
        this.sessionStartInfo = new SessionStartInfo(this.appName, null, this.testName, testBatch, appEnv, application, this.matchLevel, this.branchName, this.parentBranchName);
        Logger.verbose("startSession(): Starting server session...");
        this.runningSession = this.agentConnector.startSession(this.sessionStartInfo);
        Logger.verbose("startSession(): Server session ID is " + this.runningSession.getId());
        String testInfo = "'" + this.testName + "' of '" + this.appName + "' " + appEnv;
        if (this.runningSession.getIsNewSession()) {
            Logger.log("--- New test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = true;
        } else {
            Logger.log("--- Test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = false;
        }
    }
}

