/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesKeyboard;
import com.applitools.eyes.EyesMouse;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ScreenshotTaker;
import com.applitools.eyes.TargetWebDriverApplication;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.NetworkUtils;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EyesWebDriver
implements HasCapabilities,
HasInputDevices,
FindsByClassName,
FindsByCssSelector,
FindsById,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath,
JavascriptExecutor,
SearchContext,
TakesScreenshot,
WebDriver {
    private final URL remoteWebDriverServerUrl;
    private final String remoteWebDriverSessionId;
    private final String remoteWebDriverUserAgent;
    private final RemoteWebDriver driver;
    private final ScreenshotTaker screenshotTaker;
    private final Queue<Trigger> userInputs;

    public EyesWebDriver(RemoteWebDriver driver) throws EyesException {
        ArgumentGuard.notNull(driver, "driver");
        this.driver = driver;
        this.userInputs = new ArrayDeque<Trigger>();
        this.remoteWebDriverServerUrl = this.getRemoteWebDriverServerUrl();
        this.remoteWebDriverSessionId = this.getSessionId();
        this.remoteWebDriverUserAgent = this.getUserAgent();
        Logger.verbose("EyesWebDriver(): Driver session is " + this.remoteWebDriverSessionId + " @ " + this.remoteWebDriverServerUrl);
        if (driver instanceof TakesScreenshot) {
            Logger.verbose("EyesWebDriver(): Driver can take screenshots");
            this.screenshotTaker = null;
            return;
        }
        Logger.verbose("EyesWebDriver(): Driver can't take screenshots");
        try {
            this.screenshotTaker = new ScreenshotTaker(this.remoteWebDriverServerUrl.toURI(), this.getSessionId());
        }
        catch (URISyntaxException ex) {
            String errMsg = "Can't take screenshots!";
            Logger.log(errMsg);
            throw new EyesException(errMsg, ex);
        }
    }

    public TargetWebDriverApplication GetTargetWebDriverApplication() {
        return new TargetWebDriverApplication(this.remoteWebDriverServerUrl, this.remoteWebDriverSessionId, this.remoteWebDriverUserAgent);
    }

    public RemoteWebDriver getRemoteWebDriver() {
        return this.driver;
    }

    public void addUserInput(Trigger trigger) {
        ArgumentGuard.notNull(trigger, "trigger");
        this.userInputs.add(trigger);
    }

    public void clearUserInputs() {
        this.userInputs.clear();
    }

    public Trigger[] getUserInputs() {
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    public void get(String s) {
        this.driver.get(s);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        List foundWebElementsList = this.driver.findElements(by);
        ArrayList<WebElement> eyesWebElementsList = new ArrayList<WebElement>(foundWebElementsList.size());
        for (WebElement currentElement : foundWebElementsList) {
            if (currentElement instanceof RemoteWebElement) {
                eyesWebElementsList.add((WebElement)new EyesRemoteWebElement(this, (RemoteWebElement)currentElement));
                continue;
            }
            eyesWebElementsList.add(currentElement);
        }
        return eyesWebElementsList;
    }

    public WebElement findElement(By by) {
        Object webElement = this.driver.findElement(by);
        if (webElement instanceof RemoteWebElement) {
            webElement = new EyesRemoteWebElement(this, (RemoteWebElement)webElement);
        }
        return webElement;
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Mouse getMouse() {
        return new EyesMouse(this, this.driver.getMouse());
    }

    public Keyboard getKeyboard() {
        return new EyesKeyboard(this, this.driver.getKeyboard());
    }

    public WebElement findElementByClassName(String className) {
        return this.findElement(By.className((String)className));
    }

    public List<WebElement> findElementsByClassName(String className) {
        return this.findElements(By.className((String)className));
    }

    public WebElement findElementByCssSelector(String cssSelector) {
        return this.findElement(By.cssSelector((String)cssSelector));
    }

    public List<WebElement> findElementsByCssSelector(String cssSelector) {
        return this.findElements(By.cssSelector((String)cssSelector));
    }

    public WebElement findElementById(String id) {
        return this.findElement(By.id((String)id));
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElements(By.id((String)id));
    }

    public WebElement findElementByLinkText(String linkText) {
        return this.findElement(By.linkText((String)linkText));
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findElements(By.linkText((String)linkText));
    }

    public WebElement findElementByPartialLinkText(String partialLinkText) {
        return this.findElement(By.partialLinkText((String)partialLinkText));
    }

    public List<WebElement> findElementsByPartialLinkText(String partialLinkText) {
        return this.findElements(By.partialLinkText((String)partialLinkText));
    }

    public WebElement findElementByName(String name) {
        return this.findElement(By.name((String)name));
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElements(By.name((String)name));
    }

    public WebElement findElementByTagName(String tagName) {
        return this.findElement(By.tagName((String)tagName));
    }

    public List<WebElement> findElementsByTagName(String tagName) {
        return this.findElements(By.tagName((String)tagName));
    }

    public WebElement findElementByXPath(String path) {
        return this.findElement(By.xpath((String)path));
    }

    public List<WebElement> findElementsByXPath(String path) {
        return this.findElements(By.xpath((String)path));
    }

    public Capabilities getCapabilities() {
        return this.driver.getCapabilities();
    }

    public Object executeScript(String script, Object ... args) {
        return this.driver.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.driver.executeAsyncScript(script, args);
    }

    public <X> X getScreenshotAs(OutputType<X> xOutputType) throws WebDriverException {
        if (this.screenshotTaker == null) {
            return (X)((TakesScreenshot)this.driver).getScreenshotAs(xOutputType);
        }
        Logger.verbose("getScreenshotAs(): Driver can't take screenshot");
        if (xOutputType != OutputType.BASE64) {
            throw new EyesException("Screenshot OutputType not supported");
        }
        String screenshot = this.screenshotTaker.getScreenshot();
        return (X)xOutputType.convertFromBase64Png(screenshot);
    }

    private static URL getFirefoxServerUrl(RemoteWebDriver driver) throws EyesException {
        URL remoteWebDriverServerUrl;
        FirefoxDriver firefoxDriver = (FirefoxDriver)driver;
        CommandExecutor firefoxCommandExecutor = firefoxDriver.getCommandExecutor();
        try {
            Field connectionField = firefoxCommandExecutor.getClass().getDeclaredField("connection");
            connectionField.setAccessible(true);
            Object connectionValue = connectionField.get(firefoxCommandExecutor);
            Field delegateField = connectionValue.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            HttpCommandExecutor httpCommandExecutor = (HttpCommandExecutor)delegateField.get(connectionValue);
            remoteWebDriverServerUrl = httpCommandExecutor.getAddressOfRemoteServer();
        }
        catch (NoSuchFieldException e) {
            throw new EyesException("Failed to Remote Server Address for Firefox", e);
        }
        catch (IllegalAccessException e) {
            throw new EyesException("Failed to Remote Server Address for Firefox", e);
        }
        return remoteWebDriverServerUrl;
    }

    private URL getRemoteWebDriverServerUrl() {
        CommandExecutor commandExecutor = this.driver.getCommandExecutor();
        URL remoteWebDriverServerUrl = this.driver instanceof FirefoxDriver ? EyesWebDriver.getFirefoxServerUrl(this.driver) : ((HttpCommandExecutor)commandExecutor).getAddressOfRemoteServer();
        if (remoteWebDriverServerUrl == null) {
            throw new EyesException("Failed to get remote web driver URL!");
        }
        String webDriverHost = remoteWebDriverServerUrl.getHost();
        boolean convertToGlobalIP = webDriverHost.equals("127.0.0.1") || webDriverHost.equals("localhost");
        boolean isIE = this.driver instanceof InternetExplorerDriver;
        boolean isFireFox = this.driver instanceof FirefoxDriver;
        if (convertToGlobalIP && !isIE && !isFireFox) {
            String localIP;
            try {
                localIP = NetworkUtils.getLocalIp();
            }
            catch (SocketException e) {
                throw new EyesException("Failed to get local IP!", e);
            }
            if (localIP == null) {
                localIP = "localhost";
            }
            try {
                remoteWebDriverServerUrl = new URL(remoteWebDriverServerUrl.getProtocol(), localIP, remoteWebDriverServerUrl.getPort(), remoteWebDriverServerUrl.getPath());
            }
            catch (MalformedURLException e) {
                throw new EyesException("Could not compose URL for the remote web driver!", e);
            }
            catch (NullPointerException e) {
                throw new EyesException("Could not compose URL for the remote web driver!", e);
            }
        }
        return remoteWebDriverServerUrl;
    }

    private String getUserAgent() {
        String userAgent;
        try {
            userAgent = (String)this.driver.executeScript("return navigator.userAgent", new Object[0]);
            Logger.verbose("getUserAgent(): '" + userAgent + "'");
        }
        catch (Exception e) {
            Logger.verbose("getUserAgent(): Failed to obtain user-agent string");
            userAgent = null;
        }
        return userAgent;
    }

    private String getSessionId() {
        return this.driver.getSessionId().toString();
    }
}

