/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.Eyes;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageDeltaCompressor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.openqa.selenium.OutputType;

class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private Eyes eyes;
    private AgentConnector agentConnector;
    private RunningSession runningSession;
    private EyesWebDriver driver;
    private int maxWindowLoadTimeMilliSeconds;
    private MatchResult matchResult;
    private BufferedImage currentScreenshot;

    public MatchWindowTask(Eyes eyes, AgentConnector agentConnector, RunningSession runningSession, EyesWebDriver driver, int maxWindowLoadTime) {
        ArgumentGuard.notNull((Object)((Object)eyes), (String)"eyes");
        ArgumentGuard.notNull((Object)agentConnector, (String)"agentConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.greaterThanOrEqualToZero((int)maxWindowLoadTime, (String)"maxWindowLoadTime");
        this.eyes = eyes;
        this.agentConnector = agentConnector;
        this.runningSession = runningSession;
        this.driver = driver;
        this.maxWindowLoadTimeMilliSeconds = maxWindowLoadTime * 1000;
        this.matchResult = null;
        this.currentScreenshot = null;
    }

    private MatchWindowData createWindowData(Region region, String currentScreenshot64, String title, String tag, boolean ignoreMismatch) throws EyesException {
        byte[] compressedScreenshot;
        byte[] currentScreenshotEncoded = Base64.decodeBase64((String)currentScreenshot64);
        try {
            ByteArrayInputStream screenshotStream = new ByteArrayInputStream(currentScreenshotEncoded);
            this.currentScreenshot = ImageIO.read(screenshotStream);
            screenshotStream.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to parse screenshot!", (Throwable)e);
        }
        if (!region.equals((Object)Region.EMPTY)) {
            region.intersect(new Region(0, 0, this.currentScreenshot.getWidth(), this.currentScreenshot.getHeight()));
            if (!region.equals((Object)Region.EMPTY)) {
                this.currentScreenshot = this.currentScreenshot.getSubimage(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
                ByteArrayOutputStream pngBytesStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)this.currentScreenshot, "png", pngBytesStream);
                    pngBytesStream.flush();
                    currentScreenshotEncoded = pngBytesStream.toByteArray();
                }
                catch (IOException e) {
                    throw new EyesException("Failed to encode region", (Throwable)e);
                }
                finally {
                    try {
                        pngBytesStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        BufferedImage source = this.eyes.getLastScreenshot() != null ? this.eyes.getLastScreenshot().getImage() : null;
        try {
            compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks((BufferedImage)this.currentScreenshot, (byte[])currentScreenshotEncoded, (BufferedImage)source);
        }
        catch (IOException e) {
            throw new EyesException("Failed to compress screenshot!", (Throwable)e);
        }
        AppOutput appOutput = new AppOutput(title, null);
        return new MatchWindowData(this.eyes.getUserInputs(), appOutput, tag, ignoreMismatch, compressedScreenshot);
    }

    public MatchResult matchWindow(Region region, String tag, boolean shouldRunOnceOnTimeout) throws EyesException {
        if (0 == this.maxWindowLoadTimeMilliSeconds || shouldRunOnceOnTimeout) {
            if (shouldRunOnceOnTimeout) {
                GeneralUtils.sleep((long)this.maxWindowLoadTimeMilliSeconds);
            }
            String title = this.eyes.getTitle();
            String currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            MatchWindowData matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, false);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
        } else {
            MatchWindowData matchWindowData;
            String currentScreenshot64;
            String title;
            long start = System.currentTimeMillis();
            for (long retry = (long)this.maxWindowLoadTimeMilliSeconds; retry > 0L; retry -= System.currentTimeMillis() - start) {
                GeneralUtils.sleep((long)500L);
                title = this.eyes.getTitle();
                currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, true);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
                if (this.matchResult.getAsExpected()) break;
            }
            if (!this.matchResult.getAsExpected()) {
                title = this.eyes.getTitle();
                currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                matchWindowData = this.createWindowData(region, currentScreenshot64, title, tag, false);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
            }
        }
        EyesScreenshot lastScreenshot = new EyesScreenshot(this.currentScreenshot);
        if (!region.equals((Object)Region.EMPTY)) {
            lastScreenshot.setBounds(region);
        }
        this.eyes.setLastScreenshot(lastScreenshot);
        this.eyes.clearUserInputs();
        return this.matchResult;
    }
}

