/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.TestFailedException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.net.URI;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes
extends EyesBase {
    private static final String AGENT_ID = "eyes.selenium.java/1.16";
    private static final String GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_NORMAL_BROWSER = "return window.innerHeight";
    private static final int DEFAULT_MATCH_TIMEOUT = 2;
    private static final String GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_NORMAL_BROWSER = "return window.innerWidth";
    private static final String DOCUMENT_CLEAR_SCROLL_BARS_JAVASCRIPT = "var doc = document.documentElement;var previousOverflow = doc.style.overflow;";
    private static final String DOCUMENT_RESET_SCROLL_BARS_JAVASCRIPT = "doc.style.overflow = previousOverflow;";
    private static final String DOCUMENT_RETURN_JAVASCRIPT = "return __applitools_result;";
    private static final String GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_BAD_BROWSERS = "var doc = document.documentElement;var previousOverflow = doc.style.overflow;var __applitools_result = doc.clientWidth;doc.style.overflow = previousOverflow;return __applitools_result;";
    private static final String GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_BAD_BROWSERS = "var doc = document.documentElement;var previousOverflow = doc.style.overflow;var __applitools_result = doc.clientHeight;doc.style.overflow = previousOverflow;return __applitools_result;";
    private EyesWebDriver driver;
    private MatchWindowTask matchWindowTask;
    private int matchTimeout = 2;
    private boolean dontGetTitle = false;
    private boolean shouldMatchWindowRunOnceOnTimeout;

    public static void setLogHandler(LogHandler logHandler) {
        Logger.setLogHandler((LogHandler)logHandler);
    }

    public static void setApiKey(String apiKey) {
        EyesBase.setApiKey((String)apiKey);
    }

    public static String getApiKey() {
        return EyesBase.getApiKey();
    }

    public Eyes(URI serverUrl, boolean isDisabled) {
        super(serverUrl, isDisabled);
    }

    public Eyes(URI serverUrl) {
        this(serverUrl, false);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public String getAgentId() {
        return AGENT_ID;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel, FailureReports failureReports) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"open(): Ignored");
            return driver;
        }
        super.open(appName, testName, viewportSize, matchLevel, failureReports);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            Logger.log((String)errMsg);
            throw new EyesException(errMsg);
        }
        return this.driver;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel) {
        return this.open(driver, appName, testName, viewportSize, matchLevel, FailureReports.ON_CLOSE);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, FailureReports failureReports) {
        return this.open(driver, appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, failureReports);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        return this.open(driver, appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, null, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    protected void checkWindow(Region region, String tag) {
        MatchResult result;
        if (this.getIsDisabled()) {
            Logger.verbose((String)"CheckWindow(Region, String): Ignored");
            return;
        }
        Logger.verbose((String)("CheckWindow([" + region.toString() + "]" + ", '" + (tag != null ? tag : "") + "')"));
        if (this.runningSession == null) {
            this.startSession();
            this.matchWindowTask = new MatchWindowTask(this, this.agentConnector, this.runningSession, this.driver, this.matchTimeout);
        }
        if (!(result = this.matchWindowTask.matchWindow(region, tag, this.shouldMatchWindowRunOnceOnTimeout)).getAsExpected()) {
            this.shouldMatchWindowRunOnceOnTimeout = true;
            if (!this.runningSession.getIsNewSession()) {
                Logger.log((String)("Window Mismatch " + (tag == null ? "" : " (" + tag + ")")));
            }
            if (this.getFailureReports().equals((Object)FailureReports.IMMEDIATE)) {
                throw new TestFailedException("Mismatch found in '" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'");
            }
        }
    }

    public void checkWindow(String tag) {
        this.checkWindow(Region.EMPTY, tag);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkRegion(By selector, String tag) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"CheckRegion(Selector, String): Ignored");
            return;
        }
        WebElement element = this.driver.findElement(selector);
        Point location = element.getLocation();
        Dimension elementSize = element.getSize();
        RectangleSize size = new RectangleSize(elementSize.getWidth(), elementSize.getHeight());
        this.checkWindow(new Region(new Location(location.getX(), location.getY()), size), tag);
    }

    protected void setMatchWindowTask(MatchWindowTask matchWindowTask) {
        this.matchWindowTask = matchWindowTask;
    }

    public void setMatchTimeout(int seconds) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"setMatchTimeout(): Ignored");
            return;
        }
        Logger.verbose((String)("setMatchTimeout(" + seconds + ")"));
        ArgumentGuard.greaterThanOrEqualToZero((int)seconds, (String)"seconds");
        this.matchTimeout = seconds;
        Logger.log((String)("Match timeout set to " + seconds + " second(s)"));
    }

    protected String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                Logger.verbose((String)("getTitle(): failed (" + ex.getMessage() + ")"));
                this.dontGetTitle = true;
            }
        }
        return "";
    }

    protected RectangleSize getViewportSize() {
        try {
            try {
                int width = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_NORMAL_BROWSER, new Object[0]).toString());
                int height = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_NORMAL_BROWSER, new Object[0]).toString());
                return new RectangleSize(width, height);
            }
            catch (NumberFormatException ex) {
                Logger.verbose((String)("getViewportSize(): Browser does not support innerWidth/Height (" + ex.getMessage() + ")"));
                int width = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_WIDTH_JAVASCRIPT_FOR_BAD_BROWSERS, new Object[0]).toString());
                int height = Integer.parseInt(this.driver.executeScript(GET_VIEWPORT_HEIGHT_JAVASCRIPT_FOR_BAD_BROWSERS, new Object[0]).toString());
                return new RectangleSize(width, height);
            }
        }
        catch (Exception ex) {
            Logger.verbose((String)("getViewportSize(): only window size is available (" + ex.getMessage() + ")"));
            Dimension windowSize = this.driver.manage().window().getSize();
            return new RectangleSize(windowSize.getWidth(), windowSize.getHeight());
        }
    }

    protected void setViewportSize(RectangleSize size) {
        Dimension browserSize;
        Logger.verbose((String)("setViewportSize(" + size + ")"));
        int SLEEP = 1000;
        int RETRIES = 3;
        Dimension startingBrowserSize = new Dimension(size.getWidth(), size.getHeight());
        this.driver.manage().window().setSize(startingBrowserSize);
        int retriesLeft = 3;
        do {
            GeneralUtils.sleep((long)1000L);
            browserSize = this.driver.manage().window().getSize();
        } while (--retriesLeft > 0 && !browserSize.equals((Object)startingBrowserSize));
        if (!browserSize.equals((Object)startingBrowserSize)) {
            String errMsg = "Failed to set browser size";
            Logger.log((String)errMsg);
            throw new TestFailedException(errMsg);
        }
        RectangleSize actualViewportSize = this.getViewportSize();
        Logger.verbose((String)("setViewportSize(): initial size is " + actualViewportSize));
        this.driver.manage().window().setSize(new Dimension(2 * browserSize.width - actualViewportSize.getWidth(), 2 * browserSize.height - actualViewportSize.getHeight()));
        retriesLeft = 3;
        do {
            GeneralUtils.sleep((long)1000L);
            actualViewportSize = this.getViewportSize();
            Logger.verbose((String)("setViewportSize(): size is " + actualViewportSize));
        } while (--retriesLeft > 0 && !actualViewportSize.equals((Object)size));
        if (!actualViewportSize.equals((Object)size)) {
            String errMsg = "Failed to set browser's viewport size";
            Logger.log((String)errMsg);
            throw new TestFailedException(errMsg);
        }
        this.viewportSize = size;
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected void startSession() {
        super.startSession();
        this.shouldMatchWindowRunOnceOnTimeout = this.runningSession.getIsNewSession();
    }

    protected AppEnvironment getEnvironment() {
        AppEnvironment appEnv = super.getEnvironment();
        if (appEnv.getOs() == null) {
            Logger.verbose((String)"No OS set, checking for mobile OS...");
            try {
                Capabilities capabilities = this.driver.getCapabilities();
                String device = (String)capabilities.getCapability("device");
                if (device != null) {
                    String version = capabilities.getVersion();
                    String majorVersion = version != null ? version.split("\\.", 2)[0] : "";
                    appEnv.setOs(device + " " + majorVersion);
                    Logger.verbose((String)("Found device: " + device));
                }
            }
            catch (Exception e) {
                Logger.verbose((String)("Failed to extract OS: " + e.getMessage()));
            }
        }
        return appEnv;
    }
}

