/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Region;
import com.applitools.eyes.TextTrigger;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.remote.RemoteWebElement;

class EyesKeyboard
implements Keyboard {
    private EyesWebDriver eyesDriver;
    private Keyboard keyboard;
    private static final Region MOCK_CONTROL = new Region(0, 0, 1, 1);

    public EyesKeyboard(EyesWebDriver eyesDriver, Keyboard keyboard) {
        ArgumentGuard.notNull(eyesDriver, "eyesDriver");
        ArgumentGuard.notNull(keyboard, "keyboard");
        this.eyesDriver = eyesDriver;
        this.keyboard = keyboard;
    }

    public void sendKeys(CharSequence ... charSequences) {
        Object activeElement = this.eyesDriver.switchTo().activeElement();
        Region control = MOCK_CONTROL;
        if (activeElement instanceof RemoteWebElement) {
            activeElement = new EyesRemoteWebElement(this.eyesDriver, (RemoteWebElement)activeElement);
            control = ((EyesRemoteWebElement)((Object)activeElement)).getRegion();
        }
        for (CharSequence keys : charSequences) {
            String text = String.valueOf(keys);
            TextTrigger trigger = new TextTrigger(text, control);
            this.eyesDriver.addUserInput(trigger);
        }
        this.keyboard.sendKeys(charSequences);
    }

    public void pressKey(CharSequence keyToPress) {
        this.keyboard.pressKey(keyToPress);
    }

    public void releaseKey(CharSequence keyToRelease) {
        this.keyboard.releaseKey(keyToRelease);
    }
}

