/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.Eyes;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestResults;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;

class AgentConnector
extends RestClient {
    public AgentConnector(URI agentUri) {
        super(agentUri);
        this.endPoint = this.endPoint.path("/api/sessions/running").queryParam("format", "json");
    }

    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        ClientResponse response;
        String postData;
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", e);
        }
        this.endPoint.addFilter((ClientFilter)new HTTPBasicAuthFilter("eyes.selenium.java", Eyes.getApiKey()));
        try {
            response = (ClientResponse)this.endPoint.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)postData);
        }
        catch (RuntimeException e) {
            Logger.log("startSession(): Server request failed: " + e.getMessage());
            throw e;
        }
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        validStatusCodes.add(ClientResponse.Status.CREATED.getStatusCode());
        RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, RunningSession.class);
        int statusCode = response.getStatus();
        boolean isNewSession = statusCode == ClientResponse.Status.CREATED.getStatusCode();
        runningSession.setIsNewSession(isNewSession);
        return runningSession;
    }

    public TestResults stopSession(RunningSession runningSession, boolean isAborted) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        String sessionId = runningSession.getId();
        ClientResponse response = (ClientResponse)this.endPoint.path(sessionId).queryParam("aborted", String.valueOf(isAborted)).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        TestResults result = this.parseResponseWithJsonData(response, validStatusCodes, TestResults.class);
        return result;
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData data, String tag, boolean shouldAgentIgnoreMismatch) throws EyesException {
        String postData;
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(data, "data");
        String sessionId = runningSession.getId();
        WebResource runningSessionsEndpointWithQueryParams = this.endPoint.path(sessionId).queryParam("ignoreMismatch", String.valueOf(shouldAgentIgnoreMismatch));
        if (null != tag) {
            runningSessionsEndpointWithQueryParams = runningSessionsEndpointWithQueryParams.queryParam("tag", tag);
        }
        try {
            postData = this.jsonMapper.writeValueAsString((Object)data);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize data for matchWindow!", e);
        }
        ClientResponse response = (ClientResponse)runningSessionsEndpointWithQueryParams.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)postData);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        MatchResult result = this.parseResponseWithJsonData(response, validStatusCodes, MatchResult.class);
        return result;
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData data, String tag) throws EyesException {
        return this.matchWindow(runningSession, data, tag, false);
    }
}

