/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.Dimension;

public class RectangleSize {
    private int width;
    private int height;

    public RectangleSize(int width, int height) {
        ArgumentGuard.greaterThanZero(width, "width");
        ArgumentGuard.greaterThanZero(height, "height");
        this.width = width;
        this.height = height;
    }

    public RectangleSize(Dimension size) {
        this(size.width, size.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static RectangleSize parse(String size) {
        ArgumentGuard.notNull(size, "size");
        String[] parts = size.split("x");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Not a valid size string: " + size);
        }
        return new RectangleSize(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    public static boolean AreEqual(RectangleSize obj1, RectangleSize obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.width == obj2.width && obj1.height == obj2.height;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }
}

