/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesTargetLocator;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.EyesWebDriverScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.MouseTrigger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.TestFailedException;
import com.applitools.eyes.TextTrigger;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.net.URI;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes
extends EyesBase {
    private static final String AGENT_ID = "eyes.selenium.java/1.47";
    private static final int DEFAULT_MATCH_TIMEOUT = 2;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private EyesWebDriver driver;
    private MatchWindowTask matchWindowTask;
    private int matchTimeout = 2;
    private boolean dontGetTitle = false;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private boolean shouldForceFullPageScreenshot = false;

    public static void setLogHandler(LogHandler logHandler) {
        Logger.setLogHandler((LogHandler)logHandler);
    }

    public static void setApiKey(String apiKey) {
        EyesBase.setApiKey((String)apiKey);
    }

    public static String getApiKey() {
        return EyesBase.getApiKey();
    }

    public static void setProxy(ProxySettings proxySettings) {
        EyesBase.setProxy((ProxySettings)proxySettings);
    }

    public static ProxySettings getProxy() {
        return EyesBase.getProxy();
    }

    public Eyes(URI serverUrl, boolean isDisabled) {
        super(serverUrl, isDisabled);
    }

    public Eyes(URI serverUrl) {
        this(serverUrl, false);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public String getAgentId() {
        return AGENT_ID;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel, FailureReports failureReports) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"open(): Ignored");
            return driver;
        }
        super.open(appName, testName, viewportSize, matchLevel, failureReports);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            Logger.log((String)errMsg);
            throw new EyesException(errMsg);
        }
        return this.driver;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, MatchLevel matchLevel) {
        return this.open(driver, appName, testName, viewportSize, matchLevel, FailureReports.ON_CLOSE);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, FailureReports failureReports) {
        return this.open(driver, appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, failureReports);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        return this.open(driver, appName, testName, viewportSize, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, null, DEFAULT_MATCH_LEVEL, FailureReports.ON_CLOSE);
    }

    private void prepareToCheck() {
        if (!this.getIsOpen()) {
            throw new EyesException("Eyes not open!");
        }
        if (this.runningSession == null) {
            this.startSession();
            this.matchWindowTask = new MatchWindowTask(this, this.serverConnector, this.runningSession, this.driver, this.matchTimeout);
        }
    }

    protected void handleMatchResult(MatchResult matchResult, String tag) {
        this.lastScreenshot = matchResult.getScreenshot();
        this.clearUserInputs();
        if (!matchResult.getAsExpected()) {
            this.shouldMatchWindowRunOnceOnTimeout = true;
            if (!this.runningSession.getIsNewSession()) {
                Logger.log((String)String.format("Window mismatch '%s'", tag));
                if (this.getFailureReports() == FailureReports.IMMEDIATE) {
                    throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.sessionStartInfo.getScenarioIdOrName(), this.sessionStartInfo.getAppIdOrName()));
                }
            }
        }
    }

    public void checkWindow(int specificMatchTimeout, String tag) {
        if (this.getIsDisabled()) {
            Logger.log((String)String.format("CheckWindow(%d, '%s'): Ignored", specificMatchTimeout, tag));
            return;
        }
        Logger.log((String)String.format("CheckWindow(%d, '%s')", specificMatchTimeout, tag));
        this.prepareToCheck();
        MatchResult result = this.matchWindowTask.matchWindow(specificMatchTimeout, tag, this.shouldForceFullPageScreenshot, this.getUserInputs(), this.getLastScreenshot(), this.shouldMatchWindowRunOnceOnTimeout);
        this.handleMatchResult(result, tag);
    }

    public void checkWindow(String tag) {
        this.checkWindow(-1, tag);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkRegion(Region region, int specificMatchTimeout, String tag) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        if (this.getIsDisabled()) {
            Logger.log((String)String.format("CheckRegion([%s], %d, '%s'): Ignored", region, specificMatchTimeout, tag));
            return;
        }
        Logger.verbose((String)String.format("CheckRegion([%s], %d, '%s')", region, specificMatchTimeout, tag));
        this.prepareToCheck();
        MatchResult result = this.matchWindowTask.matchRegion(region, specificMatchTimeout, tag, this.shouldForceFullPageScreenshot, this.getUserInputs(), this.getLastScreenshot(), this.shouldMatchWindowRunOnceOnTimeout);
        this.handleMatchResult(result, tag);
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(WebElement element, int specificMatchTimeout, String tag) {
        ArgumentGuard.notNull((Object)element, (String)"element");
        if (this.getIsDisabled()) {
            Logger.log((String)String.format("CheckRegion(element, %d, '%s'): Ignored", specificMatchTimeout, tag));
            return;
        }
        Logger.log((String)String.format("CheckRegion(element, %d, '%s')", specificMatchTimeout, tag));
        this.prepareToCheck();
        MatchResult result = this.matchWindowTask.matchElement(element, specificMatchTimeout, tag, this.shouldForceFullPageScreenshot, this.getUserInputs(), this.getLastScreenshot(), this.shouldMatchWindowRunOnceOnTimeout);
        this.handleMatchResult(result, tag);
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, null);
    }

    public void checkRegion(By selector, int specificMatchTimeout, String tag) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"CheckRegion(Selector, String): Ignored");
            return;
        }
        this.checkRegion(this.driver.findElement(selector), specificMatchTimeout, tag);
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag);
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, null);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int specificMatchTimeout, String tag) {
        this.driver.switchTo().frame(frameIndex);
        this.checkRegion(selector, specificMatchTimeout, tag);
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag);
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, null);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int specificMatchTimeout, String tag) {
        this.driver.switchTo().frame(frameNameOrId);
        this.checkRegion(selector, specificMatchTimeout, tag);
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, null);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int specificMatchTimeout, String tag) {
        this.driver.switchTo().frame(frameReference);
        this.checkRegion(selector, specificMatchTimeout, tag);
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, -1, tag);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, null);
    }

    protected void setMatchWindowTask(MatchWindowTask matchWindowTask) {
        this.matchWindowTask = matchWindowTask;
    }

    public void setMatchTimeout(int seconds) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)"setMatchTimeout(): Ignored");
            return;
        }
        Logger.verbose((String)("setMatchTimeout(" + seconds + ")"));
        ArgumentGuard.greaterThanOrEqualToZero((int)seconds, (String)"seconds");
        this.matchTimeout = seconds;
        Logger.log((String)("Match timeout set to " + seconds + " second(s)"));
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.shouldForceFullPageScreenshot = shouldForce;
    }

    protected String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                Logger.verbose((String)("getTitle(): failed (" + ex.getMessage() + ")"));
                this.dontGetTitle = true;
            }
        }
        return "";
    }

    protected RectangleSize getViewportSize() {
        try {
            int width = this.driver.extractViewportWidth();
            int height = this.driver.extractViewportHeight();
            return new RectangleSize(width, height);
        }
        catch (Exception ex) {
            Logger.verbose((String)("getViewportSize(): only window size is available (" + ex.getMessage() + ")"));
            Dimension windowSize = this.driver.manage().window().getSize();
            return new RectangleSize(windowSize.getWidth(), windowSize.getHeight());
        }
    }

    protected void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)action, (String)"action");
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)cursor, (String)"cursor");
        if (this.lastScreenshot == null) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (no screenshot)", action));
            return;
        }
        EyesWebDriverScreenshot webDriverScreenshot = (EyesWebDriverScreenshot)this.lastScreenshot;
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), webDriverScreenshot.getFrameChain())) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (different frame)", action));
            return;
        }
        Location cursorInScreenshot = new Location(cursor);
        cursorInScreenshot.offset(control.getLocation());
        try {
            cursorInScreenshot = webDriverScreenshot.getLocationInScreenshot(cursorInScreenshot);
        }
        catch (OutOfBoundsException e) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (out of bounds)", action));
            return;
        }
        Region controlScreenshotIntersect = webDriverScreenshot.getIntersectedRegion(control);
        if (!controlScreenshotIntersect.isEmpty()) {
            Location l = controlScreenshotIntersect.getLocation();
            cursorInScreenshot.offset(-l.getX(), -l.getY());
        }
        MouseTrigger trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot);
        this.addUserInput((Trigger)trigger);
        Logger.verbose((String)String.format("AddMouseTrigger: Added %s", trigger));
    }

    protected void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)action, (String)"action");
        ArgumentGuard.notNull((Object)element, (String)"element");
        if (this.lastScreenshot == null) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (no screenshot)", action));
            return;
        }
        EyesWebDriverScreenshot wdLastScreenshot = (EyesWebDriverScreenshot)this.lastScreenshot;
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), wdLastScreenshot.getFrameChain())) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (different frame)", action));
            return;
        }
        Region elementRegionInScreenshot = wdLastScreenshot.getIntersectedRegion(element);
        if (elementRegionInScreenshot.isEmpty()) {
            Logger.verbose((String)String.format("AddMouseTrigger: Ignoring %s (out of bounds)", action));
            return;
        }
        MouseTrigger trigger = new MouseTrigger(action, elementRegionInScreenshot, elementRegionInScreenshot.getMiddleOffset());
        this.addUserInput((Trigger)trigger);
        Logger.verbose((String)String.format("AddMouseTrigger: Added %s", trigger));
    }

    protected void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)text, (String)"text");
        if (this.lastScreenshot == null) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (no screenshot)", text));
            return;
        }
        EyesWebDriverScreenshot wdLastScreenshot = (EyesWebDriverScreenshot)this.lastScreenshot;
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), wdLastScreenshot.getFrameChain())) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (different frame)", text));
            return;
        }
        if ((control = wdLastScreenshot.getIntersectedRegion(control)).isEmpty()) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (out of bounds)", text));
            return;
        }
        TextTrigger trigger = new TextTrigger(new Region(control), text);
        this.addUserInput((Trigger)trigger);
        Logger.verbose((String)String.format("AddTextTrigger: Added %s", trigger));
    }

    protected void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        ArgumentGuard.notNull((Object)text, (String)"text");
        if (this.lastScreenshot == null) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (no screenshot)", text));
            return;
        }
        EyesWebDriverScreenshot wdLastScreenshot = (EyesWebDriverScreenshot)this.lastScreenshot;
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), wdLastScreenshot.getFrameChain())) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (different frame)", text));
            return;
        }
        Region elementRegionInScreenshot = wdLastScreenshot.getIntersectedRegion(element);
        if (elementRegionInScreenshot.isEmpty()) {
            Logger.verbose((String)String.format("AddTextTrigger: Ignoring '%s' (out of bounds)", text));
            return;
        }
        TextTrigger trigger = new TextTrigger(elementRegionInScreenshot, text);
        this.addUserInput((Trigger)trigger);
        Logger.verbose((String)String.format("AddTextTrigger: added %s", trigger));
    }

    protected void setViewportSize(RectangleSize size) {
        Dimension browserSize;
        Logger.verbose((String)("setViewportSize(" + size + ")"));
        int SLEEP = 1000;
        int RETRIES = 3;
        Dimension startingBrowserSize = new Dimension(size.getWidth(), size.getHeight());
        FrameChain originalFrame = this.driver.getFrameChain();
        this.driver.switchTo().defaultContent();
        int retriesLeft = 3;
        Logger.verbose((String)("Trying to set browser size to: " + startingBrowserSize));
        do {
            this.driver.manage().window().setSize(startingBrowserSize);
            GeneralUtils.sleep((long)1000L);
            browserSize = this.driver.manage().window().getSize();
            Logger.verbose((String)("Current browser size: " + browserSize));
        } while (--retriesLeft > 0 && !browserSize.equals((Object)startingBrowserSize));
        if (!browserSize.equals((Object)startingBrowserSize)) {
            String errMsg = "Failed to set browser size!";
            Logger.log((String)errMsg);
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException(errMsg);
        }
        RectangleSize actualViewportSize = this.getViewportSize();
        Logger.verbose((String)("setViewportSize(): initial viewport size:" + actualViewportSize));
        this.driver.manage().window().setSize(new Dimension(2 * browserSize.width - actualViewportSize.getWidth(), 2 * browserSize.height - actualViewportSize.getHeight()));
        retriesLeft = 3;
        do {
            GeneralUtils.sleep((long)1000L);
            actualViewportSize = this.getViewportSize();
            Logger.verbose((String)("setViewportSize(): viewport size: " + actualViewportSize));
        } while (--retriesLeft > 0 && !actualViewportSize.equals((Object)size));
        if (!actualViewportSize.equals((Object)size)) {
            Logger.verbose((String)"SetViewportSize(): attempting one more time...");
            browserSize = this.driver.manage().window().getSize();
            Dimension updatedBrowserSize = new Dimension(browserSize.width + (size.getWidth() - actualViewportSize.getWidth()), browserSize.height + (size.getHeight() - actualViewportSize.getHeight()));
            Logger.verbose((String)("SetViewportSize(): browser size: " + browserSize));
            Logger.verbose((String)("SetViewportSize(): required browser size: " + updatedBrowserSize));
            this.driver.manage().window().setSize(updatedBrowserSize);
            retriesLeft = 3;
            do {
                GeneralUtils.sleep((long)1000L);
                actualViewportSize = this.getViewportSize();
                Logger.verbose((String)("SetViewportSize(): browser size: " + this.driver.manage().window().getSize()));
                Logger.verbose((String)("setViewportSize(): viewport size: " + actualViewportSize));
            } while (--retriesLeft > 0 && !actualViewportSize.equals((Object)size));
        }
        if (!actualViewportSize.equals((Object)size)) {
            String errMsg = "Failed to set the viewport size.";
            Logger.log((String)errMsg);
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException(errMsg);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        this.viewportSize = size;
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected void startSession() {
        super.startSession();
        this.shouldMatchWindowRunOnceOnTimeout = this.runningSession.getIsNewSession();
    }

    protected AppEnvironment getEnvironment() {
        AppEnvironment appEnv = super.getEnvironment();
        if (appEnv.getOs() == null) {
            Logger.verbose((String)"No OS set, checking for mobile OS...");
            try {
                Capabilities capabilities = this.driver.getCapabilities();
                String device = (String)capabilities.getCapability("platformName");
                if (device != null) {
                    String version = (String)capabilities.getCapability("platformVersion");
                    String majorVersion = version != null ? version.split("\\.", 2)[0] : "";
                    appEnv.setOs(device + " " + majorVersion);
                    Logger.verbose((String)("Found device: " + device));
                }
            }
            catch (Exception e) {
                Logger.verbose((String)("Failed to extract OS: " + e.getMessage()));
            }
        }
        return appEnv;
    }
}

