/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.Eyes;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestResults;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;

class AgentConnector
extends RestClient {
    private String agentId;

    public AgentConnector(String agentId, URI agentUri) {
        super(agentUri);
        this.agentId = agentId;
        this.endPoint = this.endPoint.path("/api/sessions/running").queryParam("format", "json");
    }

    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        ClientResponse response;
        String postData;
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", e);
        }
        this.endPoint.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.agentId, Eyes.getApiKey()));
        try {
            response = (ClientResponse)this.endPoint.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)postData);
        }
        catch (RuntimeException e) {
            Logger.log("startSession(): Server request failed: " + e.getMessage());
            throw e;
        }
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        validStatusCodes.add(ClientResponse.Status.CREATED.getStatusCode());
        RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, RunningSession.class);
        int statusCode = response.getStatus();
        boolean isNewSession = statusCode == ClientResponse.Status.CREATED.getStatusCode();
        runningSession.setIsNewSession(isNewSession);
        return runningSession;
    }

    public TestResults stopSession(RunningSession runningSession, boolean isAborted) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        String sessionId = runningSession.getId();
        ClientResponse response = (ClientResponse)this.endPoint.path(sessionId).queryParam("aborted", String.valueOf(isAborted)).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        TestResults result = this.parseResponseWithJsonData(response, validStatusCodes, TestResults.class);
        return result;
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        byte[] requestData;
        byte[] jsonBytes;
        String jsonData;
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchData, "data");
        WebResource runningSessionsEndpoint = this.endPoint.path(runningSession.getId());
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize data for matchWindow!", e);
        }
        ByteArrayOutputStream jsonToBytesConverter = new ByteArrayOutputStream();
        try {
            jsonToBytesConverter.write(jsonData.getBytes("UTF-8"));
            jsonToBytesConverter.flush();
            jsonBytes = jsonToBytesConverter.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed create binary data from JSON!", e);
        }
        ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
        DataOutputStream requestDos = new DataOutputStream(requestOutputStream);
        try {
            requestDos.writeInt(jsonBytes.length);
            requestDos.flush();
            requestOutputStream.write(jsonBytes);
            requestOutputStream.write(matchData.getScreenshot());
            requestOutputStream.flush();
            requestData = requestOutputStream.toByteArray();
            requestDos.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed send check window request!", e);
        }
        ClientResponse response = (ClientResponse)runningSessionsEndpoint.type(MediaType.APPLICATION_OCTET_STREAM_TYPE).post(ClientResponse.class, (Object)requestData);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(ClientResponse.Status.OK.getStatusCode());
        MatchResult result = this.parseResponseWithJsonData(response, validStatusCodes, MatchResult.class);
        return result;
    }
}

