/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.MouseTrigger;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.internal.Coordinates;

public class EyesTouchScreen
implements TouchScreen {
    private final EyesWebDriver driver;
    private final TouchScreen touch;

    public EyesTouchScreen(EyesWebDriver driver, TouchScreen touch) {
        ArgumentGuard.notNull(driver, "driver");
        ArgumentGuard.notNull(touch, "touch");
        this.driver = driver;
        this.touch = touch;
    }

    public void singleTap(Coordinates where) {
        Location location = GeneralUtils.getPageLocation(where);
        Logger.verbose("tap(" + location + ")");
        Region fakeRegion = new Region(location.getX(), location.getY(), 1, 1);
        MouseTrigger trigger = new MouseTrigger(MouseAction.Click, fakeRegion, location);
        this.driver.addUserInput(trigger);
        this.touch.singleTap(where);
    }

    public void down(int x, int y) {
        this.touch.down(x, y);
    }

    public void up(int x, int y) {
        this.touch.up(x, y);
    }

    public void move(int x, int y) {
        this.touch.move(x, y);
    }

    public void scroll(Coordinates where, int xOffset, int yOffset) {
        this.touch.scroll(where, xOffset, yOffset);
    }

    public void doubleTap(Coordinates where) {
        Location location = GeneralUtils.getPageLocation(where);
        Logger.verbose("tap(" + location + ")");
        Region fakeRegion = new Region(location.getX(), location.getY(), 1, 1);
        MouseTrigger trigger = new MouseTrigger(MouseAction.DoubleClick, fakeRegion, location);
        this.driver.addUserInput(trigger);
        this.touch.doubleTap(where);
    }

    public void longPress(Coordinates where) {
        this.touch.longPress(where);
    }

    public void scroll(int xOffset, int yOffset) {
        this.touch.scroll(xOffset, yOffset);
    }

    public void flick(int xSpeed, int ySpeed) {
        this.touch.flick(xSpeed, ySpeed);
    }

    public void flick(Coordinates where, int xOffset, int yOffset, int speed) {
        this.touch.flick(where, xOffset, yOffset, speed);
    }
}

