/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AgentConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RunningSession;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageDeltaCompressor;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.openqa.selenium.OutputType;

class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private AgentConnector agentConnector;
    private RunningSession runningSession;
    private EyesWebDriver driver;
    private int maxWindowLoadTimeMilliSeconds;
    private MatchResult matchResult;
    private boolean dontGetTitle;
    private BufferedImage lastCheckedWindow;
    BufferedImage currentScreenshot;

    public MatchWindowTask(AgentConnector agentConnector, RunningSession runningSession, EyesWebDriver driver, int maxWindowLoadTime) {
        ArgumentGuard.notNull(agentConnector, "agentConnector");
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(driver, "driver");
        ArgumentGuard.greaterThanOrEqualToZero(maxWindowLoadTime, "maxWindowLoadTime");
        this.agentConnector = agentConnector;
        this.runningSession = runningSession;
        this.driver = driver;
        this.maxWindowLoadTimeMilliSeconds = maxWindowLoadTime * 1000;
        this.matchResult = null;
        this.lastCheckedWindow = null;
        this.currentScreenshot = null;
    }

    private MatchWindowData createWindowData(String currentScreenshot64, String title, String tag, boolean ignoreMismatch) throws EyesException {
        byte[] compressedScreenshot;
        byte[] currentScreenshotEncoded = Base64.decodeBase64((String)currentScreenshot64);
        try {
            ByteArrayInputStream screenshotStream = new ByteArrayInputStream(currentScreenshotEncoded);
            this.currentScreenshot = ImageIO.read(screenshotStream);
            screenshotStream.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to parse screenshot!", e);
        }
        try {
            compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks(this.currentScreenshot, currentScreenshotEncoded, this.lastCheckedWindow);
        }
        catch (IOException e) {
            throw new EyesException("Failed to compress screenshot!", e);
        }
        AppOutput appOutput = new AppOutput(title, null);
        return new MatchWindowData(this.driver.getUserInputs(), appOutput, tag, ignoreMismatch, compressedScreenshot);
    }

    public MatchResult matchWindow(String tag, boolean shouldRunOnceOnTimeout) throws EyesException {
        if (0 == this.maxWindowLoadTimeMilliSeconds || shouldRunOnceOnTimeout) {
            if (shouldRunOnceOnTimeout) {
                GeneralUtils.sleep(this.maxWindowLoadTimeMilliSeconds);
            }
            String title = this.getTitle();
            String currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            MatchWindowData matchWindowData = this.createWindowData(currentScreenshot64, title, tag, false);
            this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
        } else {
            MatchWindowData matchWindowData;
            String currentScreenshot64;
            String title;
            int timesToRun = this.maxWindowLoadTimeMilliSeconds / 500 - 1;
            for (int i = 0; i < timesToRun; ++i) {
                GeneralUtils.sleep(500L);
                title = this.getTitle();
                currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                matchWindowData = this.createWindowData(currentScreenshot64, title, tag, true);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
                if (this.matchResult.getAsExpected()) break;
            }
            if (!this.matchResult.getAsExpected()) {
                title = this.getTitle();
                currentScreenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                matchWindowData = this.createWindowData(currentScreenshot64, title, tag, false);
                this.matchResult = this.agentConnector.matchWindow(this.runningSession, matchWindowData);
            }
        }
        this.lastCheckedWindow = this.currentScreenshot;
        this.driver.clearUserInputs();
        return this.matchResult;
    }

    private String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                Logger.verbose("getTitle(): failed (" + ex.getMessage() + ")");
                this.dontGetTitle = true;
            }
        }
        return "";
    }
}

