/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.Location;
import com.applitools.utils.ArgumentGuard;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.openqa.selenium.Point;
import org.openqa.selenium.interactions.internal.Coordinates;

public class GeneralUtils {
    private static final String DATE_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private GeneralUtils() {
    }

    public static String readToEnd(InputStream inputStream) throws IOException {
        int length;
        ArgumentGuard.notNull(inputStream, "inputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray());
    }

    public static String toISO8601DateTime(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static Calendar fromISO8601DateTime(String dateTime) throws ParseException {
        ArgumentGuard.notNull(dateTime, "dateTime");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601);
        Calendar cal = Calendar.getInstance();
        cal.setTime(formatter.parse(dateTime));
        return cal;
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("sleep interrupted", ex);
        }
    }

    public static Location getPageLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.onPage();
        return new Location(p.getX(), p.getY());
    }

    public static Location getViewportLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.inViewPort();
        return new Location(p.getX(), p.getY());
    }
}

