/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.EyesSeleniumUtils;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.internal.Coordinates;

public class EyesTouchScreen
implements TouchScreen {
    private final Logger logger;
    private final EyesWebDriver driver;
    private final TouchScreen touch;

    public EyesTouchScreen(Logger logger, EyesWebDriver driver, TouchScreen touch) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)touch, (String)"touch");
        this.logger = logger;
        this.driver = driver;
        this.touch = touch;
    }

    public void singleTap(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("tap(" + location + ")");
        this.driver.getEyes().addMouseTrigger(MouseAction.Click, Region.EMPTY, location);
        this.touch.singleTap(where);
    }

    public void down(int x, int y) {
        this.touch.down(x, y);
    }

    public void up(int x, int y) {
        this.touch.up(x, y);
    }

    public void move(int x, int y) {
        this.touch.move(x, y);
    }

    public void scroll(Coordinates where, int xOffset, int yOffset) {
        this.touch.scroll(where, xOffset, yOffset);
    }

    public void doubleTap(Coordinates where) {
        Location location = EyesSeleniumUtils.getPageLocation(where);
        this.logger.verbose("tap(" + location + ")");
        this.driver.getEyes().addMouseTrigger(MouseAction.DoubleClick, Region.EMPTY, location);
        this.touch.doubleTap(where);
    }

    public void longPress(Coordinates where) {
        this.touch.longPress(where);
    }

    public void scroll(int xOffset, int yOffset) {
        this.touch.scroll(xOffset, yOffset);
    }

    public void flick(int xSpeed, int ySpeed) {
        this.touch.flick(xSpeed, ySpeed);
    }

    public void flick(Coordinates where, int xOffset, int yOffset, int speed) {
        this.touch.flick(where, xOffset, yOffset, speed);
    }
}

