/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.EyesWebDriverScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.openqa.selenium.OutputType;

public class FullPageCaptureAlgorithm {
    private static final int MAX_SCROLL_BAR_SIZE = 50;
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    private final Logger logger;
    private final EyesWebDriver driver;

    public FullPageCaptureAlgorithm(Logger logger, EyesWebDriver driver) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.logger = logger;
        this.driver = driver;
    }

    public BufferedImage getStitchedRegion(RegionProvider regionProvider, PositionProvider positionProvider) {
        Location currentPosition;
        this.logger.verbose("getStitchedRegion()");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("Region to check: %s", regionProvider.getRegion()));
        this.logger.verbose(String.format("Coordinates type: %s", regionProvider.getCoordinatesType()));
        Location originalPosition = positionProvider.getCurrentPosition();
        int setPositionRetries = 3;
        do {
            positionProvider.setPosition(new Location(0, 0));
            GeneralUtils.sleep((long)150L);
        } while ((currentPosition = positionProvider.getCurrentPosition()).getX() != 0 && currentPosition.getY() != 0 && --setPositionRetries > 0);
        if (currentPosition.getX() != 0 || currentPosition.getY() != 0) {
            positionProvider.setPosition(originalPosition);
            throw new EyesException("Couldn't set position to the to the top/left corner!");
        }
        RectangleSize entireSize = positionProvider.getEntireSize();
        this.logger.verbose("Entire size of region context: " + entireSize);
        this.logger.verbose("Getting top/left screenshot as base64...");
        String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done getting base64! Getting BufferedImage..");
        BufferedImage image = ImageUtils.imageFromBase64((String)screenshot64);
        this.logger.verbose("Done! Creating screenshot object...");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, image);
        this.logger.verbose("Done! Getting region in screenshot...");
        Region regionInScreenshot = screenshot.convertRegionLocation(regionProvider.getRegion(), regionProvider.getCoordinatesType(), CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Done! Region in screenshot: " + regionInScreenshot);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        if (!regionInScreenshot.isEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)regionInScreenshot);
        }
        if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
            positionProvider.setPosition(originalPosition);
            return image;
        }
        RectangleSize partImageSize = new RectangleSize(image.getWidth(), Math.max(image.getHeight() - 50, 10));
        this.logger.verbose(String.format("Total size: %s, image part size: %s", entireSize, partImageSize));
        Region entirePage = new Region(Location.ZERO, entireSize);
        Iterable imageParts = entirePage.getSubRegions(partImageSize);
        this.logger.verbose("Creating stitchedImage container. Size: " + entireSize);
        BufferedImage stitchedImage = new BufferedImage(entireSize.getWidth(), entireSize.getHeight(), image.getType());
        this.logger.verbose("Done! Adding initial screenshot..");
        Raster initialPart = image.getData();
        this.logger.verbose(String.format("Initial part:(0,0)[%d x %d]", initialPart.getWidth(), initialPart.getHeight()));
        stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.logger.verbose("Done!");
        this.logger.verbose("Getting the rest of the image parts...");
        for (Region partRegion : imageParts) {
            if (partRegion.getLeft() == 0 && partRegion.getTop() == 0) continue;
            this.logger.verbose(String.format("Taking screenshot for %s", partRegion));
            positionProvider.setPosition(partRegion.getLocation());
            GeneralUtils.sleep((long)100L);
            currentPosition = positionProvider.getCurrentPosition();
            this.logger.verbose(String.format("Set position to %s", currentPosition));
            this.logger.verbose("Get screenshot as base64...");
            String part64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating the image object...");
            BufferedImage partImage = ImageUtils.imageFromBase64((String)part64);
            this.logger.verbose("Done!");
            if (!regionInScreenshot.isEmpty()) {
                partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)regionInScreenshot);
            }
            this.logger.verbose("Stitching part into the image container...");
            stitchedImage.getRaster().setRect(currentPosition.getX(), currentPosition.getY(), partImage.getData());
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Stitching done!");
        positionProvider.setPosition(originalPosition);
        return stitchedImage;
    }
}

