/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.remote.RemoteWebDriver;

class ScrollPositionProvider
implements PositionProvider {
    protected final Logger logger;
    protected final RemoteWebDriver driver;

    public ScrollPositionProvider(Logger logger, RemoteWebDriver driver) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.logger = logger;
        this.driver = driver;
    }

    public ScrollPositionProvider(Logger logger, EyesWebDriver driver) {
        this(logger, driver.getRemoteWebDriver());
    }

    public Location getCurrentPosition() {
        this.logger.verbose("getCurrentScrollPosition()");
        Object xo = this.driver.executeScript("return window.scrollX", new Object[0]);
        if (xo == null && (xo = this.driver.executeScript("var doc = document.documentElement; var left = (window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0); return left", new Object[0])) == null) {
            throw new EyesException("Could not get left scroll position!");
        }
        Object yo = this.driver.executeScript("return window.scrollY", new Object[0]);
        if (yo == null && (yo = this.driver.executeScript("var doc = document.documentElement; var top = (window.pageYOffset || doc.scrollTop)  - (doc.clientTop || 0); return top", new Object[0])) == null) {
            throw new EyesException("Could not get top scroll position");
        }
        int x = Integer.parseInt(xo.toString());
        int y = Integer.parseInt(yo.toString());
        Location result = new Location(x, y);
        this.logger.verbose(String.format("Current position: %s", result));
        return result;
    }

    public void setPosition(Location location) {
        this.logger.verbose(String.format("Scrolling to %s", location));
        this.driver.executeScript(String.format("window.scrollTo(%d,%d)", location.getX(), location.getY()), new Object[0]);
        this.logger.verbose("Done scrolling!");
    }

    public RectangleSize getEntireSize() {
        this.logger.verbose("getEntireSize()");
        int scrollWidth = Integer.parseInt(this.driver.executeScript("return document.documentElement.scrollWidth", new Object[0]).toString());
        int bodyScrollWidth = Integer.parseInt(this.driver.executeScript("return document.body.scrollWidth", new Object[0]).toString());
        int totalWidth = Math.max(scrollWidth, bodyScrollWidth);
        int clientHeight = Integer.parseInt(this.driver.executeScript("return document.documentElement.clientHeight", new Object[0]).toString());
        int bodyClientHeight = Integer.parseInt(this.driver.executeScript("return document.body.clientHeight", new Object[0]).toString());
        int scrollHeight = Integer.parseInt(this.driver.executeScript("return document.documentElement.scrollHeight", new Object[0]).toString());
        int bodyScrollHeight = Integer.parseInt(this.driver.executeScript("return document.body.scrollHeight", new Object[0]).toString());
        int maxDocumentElementHeight = Math.max(clientHeight, scrollHeight);
        int maxBodyHeight = Math.max(bodyClientHeight, bodyScrollHeight);
        int totalHeight = Math.max(maxDocumentElementHeight, maxBodyHeight);
        RectangleSize result = new RectangleSize(totalWidth, totalHeight);
        this.logger.verbose(String.format("Entire size: %s", result));
        return result;
    }
}

