/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.EyesDriverOperationException;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.internal.Coordinates;

public class EyesSeleniumUtils {
    private static final String JS_GET_VIEWPORT_SIZE = "var height = undefined;var width = undefined;  if (window.innerHeight) {height = window.innerHeight;}  else if (document.documentElement && document.documentElement.clientHeight) {height = document.documentElement.clientHeight;}  else { var b = document.getElementsByTagName('body')[0]; if (b.clientHeight) {height = b.clientHeight;}}; if (window.innerWidth) {width = window.innerWidth;} else if (document.documentElement && document.documentElement.clientWidth) {width = document.documentElement.clientWidth;} else { var b = document.getElementsByTagName('body')[0]; if (b.clientWidth) {width = b.clientWidth;}};return [width, height];";
    private static final String JS_GET_CURRENT_SCROLL_POSITION = "var doc = document.documentElement; var x = window.scrollX || ((window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0)); var y = window.scrollY || ((window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0));return [x, y];";
    private static final String JS_GET_CONTENT_ENTIRE_SIZE = "var scrollWidth = document.documentElement.scrollWidth; var bodyScrollWidth = document.body.scrollWidth; var totalWidth = Math.max(scrollWidth, bodyScrollWidth); var clientHeight = document.documentElement.clientHeight; var bodyClientHeight = document.body.clientHeight; var scrollHeight = document.documentElement.scrollHeight; var bodyScrollHeight = document.body.scrollHeight; var maxDocElementHeight = Math.max(clientHeight, scrollHeight); var maxBodyHeight = Math.max(bodyClientHeight, bodyScrollHeight); var totalHeight = Math.max(maxDocElementHeight, maxBodyHeight); return [totalWidth, totalHeight];";

    public static Location getPageLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.onPage();
        return new Location(p.getX(), p.getY());
    }

    public static Location getViewportLocation(Coordinates coordinates) {
        if (coordinates == null) {
            return null;
        }
        Point p = coordinates.inViewPort();
        return new Location(p.getX(), p.getY());
    }

    public static boolean isMobileDevice(WebDriver driver) {
        return driver instanceof AppiumDriver;
    }

    public static boolean isLandscapeOrientation(WebDriver driver) {
        if (EyesSeleniumUtils.isMobileDevice(driver)) {
            AppiumDriver appiumDriver = (AppiumDriver)driver;
            try {
                String originalContext = appiumDriver.getContext();
                if (appiumDriver.getContextHandles().size() > 1 && !originalContext.equalsIgnoreCase("NATIVE_APP")) {
                    appiumDriver.context("NATIVE_APP");
                } else {
                    originalContext = null;
                }
                ScreenOrientation orientation = appiumDriver.getOrientation();
                if (originalContext != null) {
                    appiumDriver.context(originalContext);
                }
                return orientation == ScreenOrientation.LANDSCAPE;
            }
            catch (Exception e) {
                throw new EyesDriverOperationException("Failed to get orientation!", e);
            }
        }
        return false;
    }

    public static String setOverflow(JavascriptExecutor executor, String value) {
        String script = value == null ? "var origOverflow = document.documentElement.style.overflow; document.documentElement.style.overflow = undefined; return origOverflow" : String.format("var origOverflow = document.documentElement.style.overflow; document.documentElement.style.overflow = \"%s\"; return origOverflow", value);
        return (String)executor.executeScript(script, new Object[0]);
    }

    public static String hideScrollbars(JavascriptExecutor executor, int stabilizationTimeout) {
        String originalOverflow = EyesSeleniumUtils.setOverflow(executor, "hidden");
        if (stabilizationTimeout > 0) {
            try {
                Thread.sleep(stabilizationTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return originalOverflow;
    }

    public static Location getCurrentScrollPosition(JavascriptExecutor executor) {
        List positionAsList = (List)executor.executeScript(JS_GET_CURRENT_SCROLL_POSITION, new Object[0]);
        return new Location(((Long)positionAsList.get(0)).intValue(), ((Long)positionAsList.get(1)).intValue());
    }

    public static void setCurrentScrollPosition(JavascriptExecutor executor, Location location) {
        executor.executeScript(String.format("window.scrollTo(%d,%d)", location.getX(), location.getY()), new Object[0]);
    }

    public static RectangleSize getCurrentFrameContentEntireSize(JavascriptExecutor executor) {
        List esAsList = (List)executor.executeScript(JS_GET_CONTENT_ENTIRE_SIZE, new Object[0]);
        return new RectangleSize(((Long)esAsList.get(0)).intValue(), ((Long)esAsList.get(1)).intValue());
    }

    public static RectangleSize executeViewportSizeExtraction(JavascriptExecutor executor) {
        List vsAsList = (List)executor.executeScript(JS_GET_VIEWPORT_SIZE, new Object[0]);
        return new RectangleSize(((Long)vsAsList.get(0)).intValue(), ((Long)vsAsList.get(1)).intValue());
    }

    public static RectangleSize extractViewportSize(Logger logger, WebDriver driver) {
        logger.verbose("extractViewportSize()");
        try {
            return EyesSeleniumUtils.executeViewportSizeExtraction((JavascriptExecutor)driver);
        }
        catch (Exception ex) {
            logger.verbose(String.format("Failed to extract viewport size using Javascript: %s", ex.getMessage()));
            logger.verbose("Using window size as viewport size.");
            Dimension windowSize = driver.manage().window().getSize();
            int width = windowSize.getWidth();
            int height = windowSize.getHeight();
            try {
                if (EyesSeleniumUtils.isLandscapeOrientation(driver) && height > width) {
                    int height2 = width;
                    width = height;
                    height = height2;
                }
            }
            catch (WebDriverException e) {
                // empty catch block
            }
            logger.verbose(String.format("Done! Size %d x %d", width, height));
            return new RectangleSize(width, height);
        }
    }

    public static void setViewportSize(Logger logger, WebDriver driver, RectangleSize size) {
        logger.verbose("setViewportSize(" + size + ")");
        ArgumentGuard.notNull((Object)size, (String)"size");
        int SLEEP = 1000;
        int RETRIES = 3;
        driver.manage().window().setPosition(new Point(0, 0));
        RectangleSize actualViewportSize = EyesSeleniumUtils.extractViewportSize(logger, driver);
        logger.verbose("Initial viewport size:" + actualViewportSize);
        if (size.getWidth() == actualViewportSize.getWidth() && size.getHeight() == actualViewportSize.getHeight()) {
            logger.verbose("Required size already set.");
            return;
        }
        Dimension browserSize = driver.manage().window().getSize();
        logger.verbose("Current browser size: " + browserSize);
        Dimension requiredBrowserSize = new Dimension(browserSize.width + (size.getWidth() - actualViewportSize.getWidth()), browserSize.height + (size.getHeight() - actualViewportSize.getHeight()));
        logger.verbose("Trying to set browser size to: " + requiredBrowserSize);
        int retriesLeft = 3;
        do {
            driver.manage().window().setSize(requiredBrowserSize);
            GeneralUtils.sleep((long)1000L);
            browserSize = driver.manage().window().getSize();
            logger.verbose("Current browser size: " + browserSize);
        } while (--retriesLeft > 0 && !browserSize.equals((Object)requiredBrowserSize));
        if (!browserSize.equals((Object)requiredBrowserSize)) {
            throw new EyesException("Failed to set browser size!");
        }
        actualViewportSize = EyesSeleniumUtils.extractViewportSize(logger, driver);
        logger.verbose("Current viewport size: " + actualViewportSize);
        if (!actualViewportSize.equals((Object)size)) {
            logger.verbose("Attempting one more time...");
            browserSize = driver.manage().window().getSize();
            requiredBrowserSize = new Dimension(browserSize.width + (size.getWidth() - actualViewportSize.getWidth()), browserSize.height + (size.getHeight() - actualViewportSize.getHeight()));
            logger.verbose("Browser size: " + browserSize);
            logger.verbose("Required browser size: " + requiredBrowserSize);
            retriesLeft = 3;
            do {
                driver.manage().window().setSize(requiredBrowserSize);
                GeneralUtils.sleep((long)1000L);
                actualViewportSize = EyesSeleniumUtils.extractViewportSize(logger, driver);
                logger.verbose("Browser size: " + driver.manage().window().getSize());
                logger.verbose("Viewport size: " + actualViewportSize);
            } while (--retriesLeft > 0 && !actualViewportSize.equals((Object)size));
        }
        if (!actualViewportSize.equals((Object)size)) {
            throw new EyesException("Failed to set the viewport size.");
        }
    }

    public static boolean isAndroid(WebDriver driver) {
        return driver instanceof AndroidDriver;
    }

    public static boolean isIOS(WebDriver driver) {
        return driver instanceof IOSDriver;
    }

    public static String getPlatformVersion(HasCapabilities driver) {
        Capabilities capabilities = driver.getCapabilities();
        Object platformVersionObj = capabilities.getCapability("platformVersion");
        return platformVersionObj == null ? null : String.valueOf(platformVersionObj);
    }

    public static float getDevicePixelRatio(JavascriptExecutor executor) {
        return Float.parseFloat(executor.executeScript("return window.devicePixelRatio", new Object[0]).toString());
    }
}

