/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CssTranslatePositionMemento;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionMemento;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.EyesSeleniumUtils;
import org.openqa.selenium.JavascriptExecutor;

class CssTranslatePositionProvider
implements PositionProvider {
    private final Logger logger;
    private final JavascriptExecutor executor;
    private Location lastSetPosition;

    public CssTranslatePositionProvider(Logger logger, JavascriptExecutor executor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        this.logger = logger;
        this.executor = executor;
    }

    public Location getCurrentPosition() {
        this.logger.verbose("position to return: " + this.lastSetPosition);
        return this.lastSetPosition;
    }

    public void setPosition(Location location) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        this.logger.verbose("Setting position to: " + location);
        EyesSeleniumUtils.translateTo(this.executor, location);
        this.logger.verbose("Done!");
        this.lastSetPosition = location;
    }

    public RectangleSize getEntireSize() {
        RectangleSize entireSize = EyesSeleniumUtils.getCurrentFrameContentEntireSize(this.executor);
        this.logger.verbose("Entire size: " + entireSize);
        return entireSize;
    }

    public PositionMemento getState() {
        return new CssTranslatePositionMemento(EyesSeleniumUtils.getCurrentTransform(this.executor));
    }

    public void restoreState(PositionMemento state) {
        EyesSeleniumUtils.setTransform(this.executor, ((CssTranslatePositionMemento)state).getTransform());
    }
}

