/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.ContextBasedScaleProvider;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CssTranslatePositionProvider;
import com.applitools.eyes.ElementPositionProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesTargetLocator;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.EyesWebDriverScreenshot;
import com.applitools.eyes.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.FixedScaleProvider;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.FullPageCaptureAlgorithm;
import com.applitools.eyes.ImageRotation;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.ScaleMethod;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScrollPositionProvider;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.StitchMode;
import com.applitools.eyes.TakesScreenshotImageProvider;
import com.applitools.eyes.TestFailedException;
import com.applitools.eyes.TimedAppOutput;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.EyesSeleniumUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.net.URI;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class Eyes
extends EyesBase {
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int RESPONSE_TIME_DEFAULT_DEADLINE = 10;
    private static final int RESPONSE_TIME_DEFAULT_DIFF_FROM_DEADLINE = 20;
    private EyesWebDriver driver;
    private boolean dontGetTitle = false;
    private boolean forceFullPageScreenshot = false;
    private boolean checkFrameOrElement = false;
    private RegionProvider regionToCheck = null;
    private boolean hideScrollbars = false;
    private ImageRotation rotation;
    private double devicePixelRatio = 0.0;
    private StitchMode stitchMode = StitchMode.SCROLL;

    public Eyes(URI serverUrl) {
        super(serverUrl);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/2.26";
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.forceFullPageScreenshot = shouldForce;
    }

    public boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public void setStitchMode(StitchMode mode) {
        this.stitchMode = mode;
        if (this.driver != null) {
            switch (mode) {
                case CSS: {
                    this.setPositionProvider(new CssTranslatePositionProvider(this.logger, this.driver));
                    break;
                }
                default: {
                    this.setPositionProvider(new ScrollPositionProvider(this.logger, this.driver));
                }
            }
        }
    }

    public StitchMode getStitchMode() {
        return this.stitchMode;
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.hideScrollbars = shouldHide;
    }

    public boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        return this.open(driver, appName, testName, viewportSize, null);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, null, null);
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return driver;
        }
        this.openBase(appName, testName, viewportSize, sessionType);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        this.devicePixelRatio = 0.0;
        switch (this.getStitchMode()) {
            case CSS: {
                this.setPositionProvider(new CssTranslatePositionProvider(this.logger, this.driver));
                break;
            }
            default: {
                this.setPositionProvider(new ScrollPositionProvider(this.logger, this.driver));
            }
        }
        this.driver.setRotation(this.rotation);
        return this.driver;
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, SessionType sessionType) {
        return this.open(driver, appName, testName, null, sessionType);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.checkWindow(-1, tag);
    }

    public void checkWindow(int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckWindow(%d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.logger.log(String.format("CheckWindow(%d, '%s')", matchTimeout, tag));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return Region.EMPTY;
            }

            public CoordinatesType getCoordinatesType() {
                return null;
            }
        }, tag, false, matchTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWindow(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.open(driver, appName, testName, viewportSize);
        try {
            this.checkWindow(testName);
            this.close();
        }
        finally {
            this.abortIfNotClosed();
        }
    }

    public void testWindow(WebDriver driver, String appName, String testName) {
        this.testWindow(driver, appName, testName, null);
    }

    public void testWindow(WebDriver driver, String testName, RectangleSize viewportSize) {
        this.testWindow(driver, null, testName, viewportSize);
    }

    public void testWindow(WebDriver driver, String testName) {
        this.testWindow(driver, testName, (RectangleSize)null);
    }

    public void testResponseTime(final WebDriver driver, String appName, String testName, final WebDriverAction action, int deadline, int timeout) {
        this.open(driver, appName, testName, SessionType.PROGRESSION);
        Runnable runnableAction = null;
        if (action != null) {
            runnableAction = new Runnable(){

                public void run() {
                    action.drive(driver);
                }
            };
        }
        MatchWindowDataWithScreenshot result = super.testResponseTimeBase(new RegionProvider(){

            public Region getRegion() {
                return Region.EMPTY;
            }

            public CoordinatesType getCoordinatesType() {
                return null;
            }
        }, runnableAction, deadline, timeout, 5000L);
        this.logger.verbose("Checking if deadline was exceeded...");
        boolean deadlineExceeded = true;
        if (result != null) {
            TimedAppOutput tao = (TimedAppOutput)result.getMatchWindowData().getAppOutput();
            long resultElapsed = tao.getElapsed();
            long deadlineMs = deadline * 1000;
            this.logger.verbose(String.format("Deadline: %d, Elapsed time for match: %d", deadlineMs, resultElapsed));
            deadlineExceeded = resultElapsed > deadlineMs;
        }
        this.logger.verbose("Deadline exceeded? " + deadlineExceeded);
        this.closeResponseTime(deadlineExceeded);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline) {
        this.testResponseTime(driver, appName, testName, action, deadline, deadline + 20);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action) {
        this.testResponseTime(driver, appName, testName, action, 10, 30);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline) {
        this.testResponseTime(driver, appName, testName, null, deadline, deadline + 20);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName) {
        this.testResponseTime(driver, appName, testName, null, 10, 30);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline, int timeout, RectangleSize viewportSize) {
        this.setViewportSize(driver, viewportSize);
        this.testResponseTime(driver, appName, testName, action, deadline, timeout);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, int deadline, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, action, deadline, deadline + 20, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, WebDriverAction action, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, action, 10, 30, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline, int timeout, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, null, deadline, timeout, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, int deadline, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, deadline, deadline + 20, viewportSize);
    }

    public void testResponseTime(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.testResponseTime(driver, appName, testName, 10, 30, viewportSize);
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(final Region region, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion([%s], %d, '%s'): Ignored", region, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.logger.verbose(String.format("CheckRegion([%s], %d, '%s')", region, matchTimeout, tag));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return region;
            }

            public CoordinatesType getCoordinatesType() {
                return CoordinatesType.CONTEXT_AS_IS;
            }
        }, tag, false, matchTimeout);
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, null);
    }

    public void checkRegion(WebElement element, boolean stitchContent) {
        if (stitchContent) {
            this.checkElement(element);
        } else {
            this.checkRegion(element);
        }
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        if (stitchContent) {
            this.checkElement(element, tag);
        } else {
            this.checkRegion(element, tag);
        }
    }

    public void checkRegion(final WebElement element, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion(element, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.logger.log(String.format("CheckRegion(element, %d, '%s')", matchTimeout, tag));
        this.logger.verbose("Getting current scroll position..");
        Location originalScrollPos = this.positionProvider.getCurrentPosition();
        this.logger.verbose("Done! Getting element's location..");
        Point elementLocation = element.getLocation();
        this.logger.verbose("Done! Trying to scroll to element..");
        this.positionProvider.setPosition(new Location(elementLocation.getX(), elementLocation.getY()));
        this.logger.verbose("Done! calling checkWindowBase..");
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                Point p = element.getLocation();
                Dimension d = element.getSize();
                return new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight());
            }

            public CoordinatesType getCoordinatesType() {
                return CoordinatesType.CONTEXT_RELATIVE;
            }
        }, tag, false, matchTimeout);
        this.logger.verbose("Done! trying to scroll back to original position..");
        this.positionProvider.setPosition(originalScrollPos);
        this.logger.verbose("Done!");
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        if (stitchContent) {
            this.checkElement(element, matchTimeout, tag);
        } else {
            this.checkRegion(element, matchTimeout, tag);
        }
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, null);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        if (stitchContent) {
            this.checkElement(selector);
        } else {
            this.checkRegion(selector);
        }
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        if (stitchContent) {
            this.checkElement(selector, tag);
        } else {
            this.checkRegion(selector, tag);
        }
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion(selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.checkRegion(this.driver.findElement(selector), matchTimeout, tag);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, null, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, tag, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameIndex, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame(%d, selector, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameIndex);
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, null, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame('%s', selector, %d, '%s'): Ignored", frameNameOrId, matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameNameOrId);
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, null, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, tag, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameReference, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame(frame, selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameReference);
        if (stitchContent) {
            this.checkElement(selector, matchTimeout, tag);
        } else {
            this.checkRegion(selector, matchTimeout, tag);
        }
        this.driver.switchTo().parentFrame();
    }

    protected void updateScalingParams() {
        if (this.devicePixelRatio == 0.0) {
            this.logger.verbose("Trying to extract device pixel ratio...");
            try {
                this.devicePixelRatio = EyesSeleniumUtils.getDevicePixelRatio(this.driver);
            }
            catch (Exception e) {
                this.logger.verbose("Failed to extract device pixel ratio! Using default.");
                this.devicePixelRatio = 1.0;
            }
            this.logger.verbose(String.format("Device pixel ratio: %f", this.devicePixelRatio));
            this.logger.verbose("Setting scale provider..");
            try {
                this.scaleProviderHandler.set((Object)new ContextBasedScaleProvider(this.positionProvider.getEntireSize(), this.getViewportSize(), this.getScaleMethod(), this.devicePixelRatio));
            }
            catch (Exception e) {
                this.logger.verbose("Failed to set ContextBasedScaleProvider.");
                this.logger.verbose("Using FixedScaleProvider instead...");
                this.scaleProviderHandler.set((Object)new FixedScaleProvider(1.0 / this.devicePixelRatio));
            }
            this.logger.verbose("Done!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentFrame(int matchTimeout, String tag) {
        try {
            this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
            this.checkFrameOrElement = true;
            this.updateScalingParams();
            this.logger.verbose("Getting screenshot as base64..");
            String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            this.logger.verbose("Done! Creating image object...");
            BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
            screenshotImage = ((ScaleProvider)this.scaleProviderHandler.get()).scaleImage(screenshotImage);
            this.logger.verbose("Done! Building required object...");
            final EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            this.logger.verbose("Done!");
            this.regionToCheck = new RegionProvider(){

                public Region getRegion() {
                    return screenshot.getFrameWindow();
                }

                public CoordinatesType getCoordinatesType() {
                    return CoordinatesType.SCREENSHOT_AS_IS;
                }
            };
            super.checkWindowBase(new RegionProvider(){

                public Region getRegion() {
                    return Region.EMPTY;
                }

                public CoordinatesType getCoordinatesType() {
                    return null;
                }
            }, tag, false, matchTimeout);
        }
        finally {
            this.checkFrameOrElement = false;
            this.regionToCheck = null;
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.checkFrame(frameNameOrId, -1, null);
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.checkFrame(frameNameOrId, -1, tag);
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%s, %d, '%s'): Ignored", frameNameOrId, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)frameNameOrId, (String)"frameNameOrId");
        this.logger.log(String.format("CheckFrame(%s, %d, '%s')", frameNameOrId, matchTimeout, tag));
        this.logger.verbose("Switching to frame with name/id: " + frameNameOrId + " ...");
        this.driver.switchTo().frame(frameNameOrId);
        this.logger.verbose("Done.");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.logger.verbose("Switching to frame with index: " + frameIndex + " ...");
        this.driver.switchTo().frame(frameIndex);
        this.logger.verbose("Done!");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame...");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkFrame(element, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)frameReference, (String)"frameReference");
        this.logger.log(String.format("CheckFrame(element, %d, '%s')", matchTimeout, tag));
        this.logger.verbose("Switching to frame based on element reference...");
        this.driver.switchTo().frame(frameReference);
        this.logger.verbose("Done!");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame...");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkFrame(framePath, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)framePath, (String)"framePath");
        ArgumentGuard.greaterThanZero((long)framePath.length, (String)"framePath.length");
        this.logger.log(String.format("checkFrame(framePath, %d, '%s')", matchTimeout, tag));
        FrameChain originalFrameChain = this.driver.getFrameChain();
        this.logger.verbose("Switching to parent frame according to frames path..");
        String[] parentFramePath = new String[framePath.length - 1];
        System.arraycopy(framePath, 0, parentFramePath, 0, parentFramePath.length);
        ((EyesTargetLocator)this.driver.switchTo()).frames(parentFramePath);
        this.logger.verbose("Done! Calling checkFrame..");
        this.checkFrame(framePath[framePath.length - 1], matchTimeout, tag);
        this.logger.verbose("Done! switching to default content..");
        this.driver.switchTo().defaultContent();
        this.logger.verbose("Done! Switching back into the original frame..");
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrameChain);
        this.logger.verbose("Done!");
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, -1, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkRegionInFrame(framePath, selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)framePath, (String)"framePath");
        ArgumentGuard.greaterThanZero((long)framePath.length, (String)"framePath.length");
        this.logger.log(String.format("checkFrame(framePath, %d, '%s')", matchTimeout, tag));
        FrameChain originalFrameChain = this.driver.getFrameChain();
        this.logger.verbose("Switching to parent frame according to frames path..");
        String[] parentFramePath = new String[framePath.length - 1];
        System.arraycopy(framePath, 0, parentFramePath, 0, parentFramePath.length);
        ((EyesTargetLocator)this.driver.switchTo()).frames(parentFramePath);
        this.logger.verbose("Done! Calling checkRegionInFrame..");
        this.checkRegionInFrame(framePath[framePath.length - 1], selector, matchTimeout, tag, stitchContent);
        this.logger.verbose("Done! switching back to default content..");
        this.driver.switchTo().defaultContent();
        this.logger.verbose("Done! Switching into the original frame..");
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrameChain);
        this.logger.verbose("Done!");
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(framePath, selector, matchTimeout, tag, false);
    }

    public void checkRegionInFrame(String[] framePath, By selector, String tag) {
        this.checkRegionInFrame(framePath, selector, -1, tag);
    }

    public void checkRegionInFrame(String[] framePath, By selector) {
        this.checkRegionInFrame(framePath, selector, -1, null);
    }

    protected void checkElement(WebElement element) {
        this.checkElement(element, null);
    }

    protected void checkElement(WebElement element, String tag) {
        this.checkElement(element, -1, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkElement(WebElement element, int matchTimeout, String tag) {
        String originalOverflow = null;
        EyesRemoteWebElement eyesElement = element instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)element : new EyesRemoteWebElement(this.logger, this.driver, (RemoteWebElement)element);
        PositionProvider originalPositionProvider = this.getPositionProvider();
        try {
            this.checkFrameOrElement = true;
            this.setPositionProvider(new ElementPositionProvider(this.logger, this.driver, element));
            originalOverflow = eyesElement.getOverflow();
            eyesElement.setOverflow("hidden");
            Point p = eyesElement.getLocation();
            Dimension d = element.getSize();
            int borderLeftWidth = eyesElement.getBorderLeftWidth();
            int borderRightWidth = eyesElement.getBorderRightWidth();
            int borderTopWidth = eyesElement.getBorderTopWidth();
            int borderBottomWidth = eyesElement.getBorderBottomWidth();
            final Region elementRegion = new Region(p.getX() + borderLeftWidth, p.getY() + borderTopWidth, d.getWidth() - borderLeftWidth - borderRightWidth, d.getHeight() - borderTopWidth - borderBottomWidth);
            this.logger.verbose("Element region: " + elementRegion);
            this.regionToCheck = new RegionProvider(){

                public Region getRegion() {
                    return elementRegion;
                }

                public CoordinatesType getCoordinatesType() {
                    return CoordinatesType.CONTEXT_RELATIVE;
                }
            };
            super.checkWindowBase(new RegionProvider(){

                public Region getRegion() {
                    return Region.EMPTY;
                }

                public CoordinatesType getCoordinatesType() {
                    return null;
                }
            }, tag, false, matchTimeout);
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
        }
        catch (Throwable throwable) {
            if (originalOverflow != null) {
                eyesElement.setOverflow(originalOverflow);
            }
            this.checkFrameOrElement = false;
            this.setPositionProvider(originalPositionProvider);
            this.regionToCheck = null;
            throw throwable;
        }
        this.setPositionProvider(originalPositionProvider);
        this.regionToCheck = null;
    }

    protected void checkElement(By selector) {
        this.checkElement(selector, null);
    }

    protected void checkElement(By selector, String tag) {
        this.checkElement(selector, -1, tag);
    }

    protected void checkElement(By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckElement(selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.checkElement(this.driver.findElement(selector), matchTimeout, tag);
    }

    protected void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    protected void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    protected void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    protected void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    protected RectangleSize getViewportSize() {
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        return this.driver.getDefaultContentViewportSize();
    }

    public RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesSeleniumUtils.extractViewportSize(this.logger, driver);
    }

    protected void setViewportSize(RectangleSize size) {
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        FrameChain originalFrame = this.driver.getFrameChain();
        this.driver.switchTo().defaultContent();
        try {
            EyesSeleniumUtils.setViewportSize(this.logger, this.driver, size);
        }
        catch (EyesException e) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException("Failed to set the viewport size", (Throwable)e);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        this.viewportSize = new RectangleSize(size.getWidth(), size.getHeight());
    }

    public void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesSeleniumUtils.setViewportSize(this.logger, driver, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EyesScreenshot getScreenshot() {
        this.logger.verbose("getScreenshot()");
        this.updateScalingParams();
        String originalOverflow = null;
        if (this.hideScrollbars) {
            originalOverflow = EyesSeleniumUtils.hideScrollbars(this.driver, 200);
        }
        try {
            EyesWebDriverScreenshot result;
            TakesScreenshotImageProvider imageProvider = new TakesScreenshotImageProvider(this.logger, this.driver);
            EyesWebDriverScreenshotFactory screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
            if (this.checkFrameOrElement) {
                this.logger.verbose("Check frame/element requested");
                FullPageCaptureAlgorithm algo = new FullPageCaptureAlgorithm(this.logger);
                BufferedImage entireFrameOrElement = algo.getStitchedRegion(imageProvider, this.regionToCheck, this.positionProvider, this.positionProvider, (ScaleProvider)this.scaleProviderHandler.get(), screenshotFactory);
                this.logger.verbose("Building screenshot object...");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight()));
            } else if (this.forceFullPageScreenshot) {
                this.logger.verbose("Full page screenshot requested.");
                FrameChain originalFrame = this.driver.getFrameChain();
                this.driver.switchTo().defaultContent();
                FullPageCaptureAlgorithm algo = new FullPageCaptureAlgorithm(this.logger);
                BufferedImage fullPageImage = algo.getStitchedRegion(imageProvider, new RegionProvider(){

                    public Region getRegion() {
                        return Region.EMPTY;
                    }

                    public CoordinatesType getCoordinatesType() {
                        return null;
                    }
                }, new ScrollPositionProvider(this.logger, this.driver), this.positionProvider, (ScaleProvider)this.scaleProviderHandler.get(), screenshotFactory);
                ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
                result = new EyesWebDriverScreenshot(this.logger, this.driver, fullPageImage);
            } else {
                this.logger.verbose("Screenshot requested...");
                String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                this.logger.verbose("Done! Creating image object...");
                BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
                this.logger.verbose("Done!");
                screenshotImage = ((ScaleProvider)this.scaleProviderHandler.get()).scaleImage(screenshotImage);
                this.logger.verbose("Creating screenshot object...");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
            }
            this.logger.verbose("Done!");
            EyesWebDriverScreenshot eyesWebDriverScreenshot = result;
            return eyesWebDriverScreenshot;
        }
        finally {
            if (this.hideScrollbars) {
                EyesSeleniumUtils.setOverflow(this.driver, originalOverflow);
            }
        }
    }

    protected String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("failed (" + ex.getMessage() + ")");
                this.dontGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesSeleniumUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesSeleniumUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesSeleniumUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesSeleniumUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                    this.logger.verbose("Setting scale method for mobile.");
                    this.setScaleMethod(ScaleMethod.QUALITY);
                }
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

