/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EyesRemoteWebElement
extends RemoteWebElement {
    private final Logger logger;
    private final EyesWebDriver eyesDriver;
    private final RemoteWebElement webElement;

    public EyesRemoteWebElement(Logger logger, EyesWebDriver eyesDriver, RemoteWebElement webElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)eyesDriver, (String)"eyesDriver");
        ArgumentGuard.notNull((Object)webElement, (String)"webElement");
        this.logger = logger;
        this.eyesDriver = eyesDriver;
        this.webElement = webElement;
    }

    public Region getBounds() {
        int left = this.webElement.getLocation().getX();
        int top = this.webElement.getLocation().getY();
        int width = 0;
        int height = 0;
        try {
            width = this.webElement.getSize().getWidth();
            height = this.webElement.getSize().getHeight();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (left < 0) {
            width = Math.max(0, width + left);
            left = 0;
        }
        if (top < 0) {
            height = Math.max(0, height + top);
            top = 0;
        }
        return new Region(left, top, width, height);
    }

    public void click() {
        Region currentControl = this.getBounds();
        this.eyesDriver.getEyes().addMouseTrigger(MouseAction.Click, (WebElement)this);
        this.logger.verbose(String.format("click(%s)", currentControl));
        this.webElement.click();
    }

    public WebDriver getWrappedDriver() {
        return this.eyesDriver;
    }

    public String getId() {
        return this.webElement.getId();
    }

    public void setParent(RemoteWebDriver parent) {
        this.webElement.setParent(parent);
    }

    public void setId(String id) {
        this.webElement.setId(id);
    }

    public void setFileDetector(FileDetector detector) {
        this.webElement.setFileDetector(detector);
    }

    public void submit() {
        this.webElement.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        for (CharSequence keys : keysToSend) {
            String text = String.valueOf(keys);
            this.eyesDriver.getEyes().addTextTrigger((WebElement)this, text);
        }
        this.webElement.sendKeys(keysToSend);
    }

    public void clear() {
        this.webElement.clear();
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public String getAttribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public boolean isSelected() {
        return this.webElement.isSelected();
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public String getText() {
        return this.webElement.getText();
    }

    public String getCssValue(String propertyName) {
        return this.webElement.getCssValue(propertyName);
    }

    private WebElement wrapElement(WebElement elementToWrap) {
        Object resultElement = elementToWrap;
        if (elementToWrap instanceof RemoteWebElement) {
            resultElement = new EyesRemoteWebElement(this.logger, this.eyesDriver, (RemoteWebElement)elementToWrap);
        }
        return resultElement;
    }

    private List<WebElement> wrapElements(List<WebElement> elementsToWrap) {
        ArrayList<WebElement> wrappedElementsList = new ArrayList<WebElement>(elementsToWrap.size());
        for (WebElement currentElement : elementsToWrap) {
            if (currentElement instanceof RemoteWebElement) {
                wrappedElementsList.add((WebElement)new EyesRemoteWebElement(this.logger, this.eyesDriver, (RemoteWebElement)currentElement));
                continue;
            }
            wrappedElementsList.add(currentElement);
        }
        return wrappedElementsList;
    }

    public List<WebElement> findElements(By by) {
        return this.wrapElements(this.webElement.findElements(by));
    }

    public WebElement findElement(By by) {
        return this.wrapElement(this.webElement.findElement(by));
    }

    public WebElement findElementById(String using) {
        return this.wrapElement(this.webElement.findElementById(using));
    }

    public List<WebElement> findElementsById(String using) {
        return this.wrapElements(this.webElement.findElementsById(using));
    }

    public WebElement findElementByLinkText(String using) {
        return this.wrapElement(this.webElement.findElementByLinkText(using));
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.wrapElements(this.webElement.findElementsByLinkText(using));
    }

    public WebElement findElementByName(String using) {
        return this.wrapElement(this.webElement.findElementByName(using));
    }

    public List<WebElement> findElementsByName(String using) {
        return this.wrapElements(this.webElement.findElementsByName(using));
    }

    public WebElement findElementByClassName(String using) {
        return this.wrapElement(this.webElement.findElementByClassName(using));
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.wrapElements(this.webElement.findElementsByClassName(using));
    }

    public WebElement findElementByCssSelector(String using) {
        return this.wrapElement(this.webElement.findElementByCssSelector(using));
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.wrapElements(this.webElement.findElementsByCssSelector(using));
    }

    public WebElement findElementByXPath(String using) {
        return this.wrapElement(this.webElement.findElementByXPath(using));
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.wrapElements(this.webElement.findElementsByXPath(using));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.wrapElement(this.webElement.findElementByPartialLinkText(using));
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.wrapElements(this.webElement.findElementsByPartialLinkText(using));
    }

    public WebElement findElementByTagName(String using) {
        return this.wrapElement(this.webElement.findElementByTagName(using));
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.wrapElements(this.webElement.findElementsByTagName(using));
    }

    public boolean equals(Object obj) {
        return obj instanceof RemoteWebElement && this.webElement.equals(obj);
    }

    public int hashCode() {
        return this.webElement.hashCode();
    }

    public boolean isDisplayed() {
        return this.webElement.isDisplayed();
    }

    public Point getLocation() {
        return this.webElement.getLocation();
    }

    public Dimension getSize() {
        return this.webElement.getSize();
    }

    public Coordinates getCoordinates() {
        return this.webElement.getCoordinates();
    }

    public String toString() {
        return "EyesRemoteWebElement:" + this.webElement.toString();
    }
}

