/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Frame;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

class EyesTargetLocator
implements WebDriver.TargetLocator {
    private final Logger logger;
    private final EyesWebDriver driver;
    private final ScrollPositionProvider scrollPosition;
    private final OnWillSwitch onWillSwitch;
    private final WebDriver.TargetLocator targetLocator;

    public EyesTargetLocator(Logger logger, EyesWebDriver driver, WebDriver.TargetLocator targetLocator, OnWillSwitch onWillSwitch) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        ArgumentGuard.notNull((Object)onWillSwitch, (String)"onWillSwitch");
        this.logger = logger;
        this.driver = driver;
        this.targetLocator = targetLocator;
        this.onWillSwitch = onWillSwitch;
        this.scrollPosition = new ScrollPositionProvider(logger, driver);
    }

    public WebDriver frame(int index) {
        this.logger.verbose(String.format("EyesTargetLocator.frame(%d)", index));
        this.logger.verbose("Getting frames list...");
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        this.logger.verbose("Done! getting the specific frame...");
        WebElement targetFrame = frames.get(index);
        this.logger.verbose("Done! Making preparations...");
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, targetFrame);
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(index);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        this.logger.verbose(String.format("EyesTargetLocator.frame('%s')", nameOrId));
        this.logger.verbose("Getting frames by name...");
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0) {
            this.logger.verbose("No frames Found! Trying by id...");
            frames = this.driver.findElementsById(nameOrId);
            if (frames.size() == 0) {
                throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
            }
        }
        this.logger.verbose("Done! Making preparations..");
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, frames.get(0));
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(nameOrId);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        this.logger.verbose("EyesTargetLocator.frame(element)");
        this.logger.verbose("Making preparations..");
        this.onWillSwitch.willSwitchToFrame(TargetType.FRAME, frameElement);
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(frameElement);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver parentFrame() {
        this.logger.verbose("EyesTargetLocator.parentFrame()");
        if (this.driver.getFrameChain().size() != 0) {
            this.logger.verbose("Making preparations..");
            this.onWillSwitch.willSwitchToFrame(TargetType.PARENT_FRAME, null);
            this.logger.verbose("Done! Switching to parent frame..");
            this.targetLocator.parentFrame();
        }
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        this.logger.verbose("EyesTargetLocator.frames(frameChain)");
        for (Frame frame : frameChain) {
            this.logger.verbose("Scrolling by parent scroll position..");
            this.scrollPosition.setPosition(frame.getParentScrollPosition());
            this.logger.verbose("Done! Switching to frame...");
            this.driver.switchTo().frame(frame.getReference());
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(String[] framesPath) {
        this.logger.verbose("EyesTargetLocator.frames(framesPath)");
        for (String frameNameOrId : framesPath) {
            this.logger.verbose("Switching to frame...");
            this.driver.switchTo().frame(frameNameOrId);
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        this.logger.verbose("EyesTargetLocator.frames()");
        this.logger.verbose("Making preparations..");
        this.onWillSwitch.willSwitchToWindow(nameOrHandle);
        this.logger.verbose("Done! Switching to window..");
        this.targetLocator.window(nameOrHandle);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver defaultContent() {
        this.logger.verbose("EyesTargetLocator.defaultContent()");
        if (this.driver.getFrameChain().size() != 0) {
            this.logger.verbose("Making preparations..");
            this.onWillSwitch.willSwitchToFrame(TargetType.DEFAULT_CONTENT, null);
            this.logger.verbose("Done! Switching to default content..");
            this.targetLocator.defaultContent();
            this.logger.verbose("Done!");
        }
        return this.driver;
    }

    public WebElement activeElement() {
        this.logger.verbose("EyesTargetLocator.activeElement()");
        this.logger.verbose("Switching to element..");
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        EyesRemoteWebElement result = new EyesRemoteWebElement(this.logger, this.driver, (RemoteWebElement)element);
        this.logger.verbose("Done!");
        return result;
    }

    public Alert alert() {
        this.logger.verbose("EyesTargetLocator.alert()");
        this.logger.verbose("Switching to alert..");
        Alert result = this.targetLocator.alert();
        this.logger.verbose("Done!");
        return result;
    }

    protected static interface OnWillSwitch {
        public void willSwitchToFrame(TargetType var1, WebElement var2);

        public void willSwitchToWindow(String var1);
    }

    protected static enum TargetType {
        FRAME,
        PARENT_FRAME,
        DEFAULT_CONTENT;

    }
}

