/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

class BordersAwareElementContentLocationProvider {
    BordersAwareElementContentLocationProvider() {
    }

    public Location getLocation(Logger logger, WebElement element, Location location) {
        int topBorderWidth;
        int leftBorderWidth;
        String propValue;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)element, (String)"element");
        ArgumentGuard.notNull((Object)location, (String)"location");
        logger.verbose(String.format("BordersAdditionFrameLocationProvider(logger, element, %s)", location));
        try {
            logger.verbose("Get element border left width...");
            if (element instanceof EyesRemoteWebElement) {
                logger.verbose("Element is an EyesWebElement, using 'getComputedStyle'.");
                try {
                    propValue = ((EyesRemoteWebElement)element).getComputedStyle("border-left-width");
                }
                catch (WebDriverException e) {
                    logger.verbose(String.format("Using getComputedStyle failed: %s.", e.getMessage()));
                    logger.verbose("Using getCssValue...");
                    propValue = element.getCssValue("border-left-width");
                }
                logger.verbose("Done!");
            } else {
                logger.verbose("Element is not an EyesWebElement! (when trying to get border-left-width) Element's class: " + element.getClass().getName());
                logger.verbose("Using getCssValue...");
                propValue = element.getCssValue("border-left-width");
                logger.verbose("Done!");
            }
            leftBorderWidth = Math.round(Float.valueOf(propValue.trim().replace("px", "")).floatValue());
            logger.verbose("border-left-width: " + leftBorderWidth);
        }
        catch (WebDriverException e) {
            logger.verbose(String.format("Couldn't get the element's border-left-width: %s. Falling back to default", e.getMessage()));
            leftBorderWidth = 0;
        }
        try {
            logger.verbose("Get element's border top width...");
            if (element instanceof EyesRemoteWebElement) {
                logger.verbose("Element is an EyesWebElement, using 'getComputedStyle'.");
                try {
                    propValue = ((EyesRemoteWebElement)element).getComputedStyle("border-top-width");
                }
                catch (WebDriverException e) {
                    logger.verbose(String.format("Using getComputedStyle failed: %s.", e.getMessage()));
                    logger.verbose("Using getCssValue...");
                    propValue = element.getCssValue("border-top-width");
                }
                logger.verbose("Done!");
            } else {
                logger.verbose("Element is not an EyesWebElement (when trying to get border-top-width) Element's class: " + element.getClass().getName());
                logger.verbose("Using getCssValue...");
                propValue = element.getCssValue("border-top-width");
                logger.verbose("Done!");
            }
            topBorderWidth = Math.round(Float.valueOf(propValue.trim().replace("px", "")).floatValue());
            logger.verbose("border-top-width: " + topBorderWidth);
        }
        catch (WebDriverException e) {
            logger.verbose(String.format("Couldn't get the element's border-top-width: %s. Falling back to default", e.getMessage()));
            topBorderWidth = 0;
        }
        Location contentLocation = new Location(location);
        contentLocation.offset(leftBorderWidth, topBorderWidth);
        logger.verbose("Done!");
        return contentLocation;
    }
}

