/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.ElementPositionMemento;
import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionMemento;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

class ElementPositionProvider
implements PositionProvider {
    private final Logger logger;
    private final EyesWebDriver driver;
    private final EyesRemoteWebElement element;

    public ElementPositionProvider(Logger logger, EyesWebDriver driver, WebElement element) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.logger = logger;
        this.driver = driver;
        this.element = new EyesRemoteWebElement(logger, driver, (RemoteWebElement)element);
    }

    public Location getCurrentPosition() {
        this.logger.verbose("getCurrentScrollPosition()");
        Location result = new Location(this.element.getScrollLeft(), this.element.getScrollTop());
        this.logger.verbose(String.format("Current position: %s", result));
        return result;
    }

    public void setPosition(Location location) {
        this.logger.verbose(String.format("Scrolling element to %s", location));
        this.element.scrollTo(location);
        this.logger.verbose("Done scrolling element!");
    }

    public RectangleSize getEntireSize() {
        this.logger.verbose("getEntireSize()");
        RectangleSize result = new RectangleSize(this.element.getScrollWidth(), this.element.getScrollHeight());
        this.logger.verbose(String.format("Entire size: %s", result));
        return result;
    }

    public PositionMemento getState() {
        return new ElementPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ElementPositionMemento s = (ElementPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }
}

