/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesTargetLocator;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.EyesWebDriverScreenshot;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.Location;
import com.applitools.eyes.MouseAction;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.TestFailedException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.net.URI;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes
extends EyesBase {
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private EyesWebDriver driver;
    private boolean dontGetTitle = false;
    private boolean forceFullPageScreenshot = false;
    private boolean checkFrame = false;
    private Region frameWindowToCheck = null;
    private boolean hideScrollbars = false;

    public Eyes(URI serverUrl) {
        super(serverUrl);
    }

    public Eyes() {
        this(Eyes.getDefaultServerUrl());
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/2.9";
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.forceFullPageScreenshot = shouldForce;
    }

    public boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.hideScrollbars = shouldHide;
    }

    public boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        if (this.getIsDisabled()) {
            this.logger.verbose("open(): Ignored");
            return driver;
        }
        this.openBase(appName, testName, viewportSize);
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesWebDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesWebDriver) {
            this.driver = (EyesWebDriver)driver;
        } else {
            String errMsg = "Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
        return this.driver;
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        return this.open(driver, appName, testName, null);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.checkWindow(-1, tag);
    }

    public void checkWindow(int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckWindow(%d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.logger.log(String.format("CheckWindow(%d, '%s')", matchTimeout, tag));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return Region.EMPTY;
            }

            public CoordinatesType getCoordinatesType() {
                return null;
            }
        }, tag, false, matchTimeout);
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(final Region region, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion([%s], %d, '%s'): Ignored", region, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.logger.verbose(String.format("CheckRegion([%s], %d, '%s')", region, matchTimeout, tag));
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return region;
            }

            public CoordinatesType getCoordinatesType() {
                return CoordinatesType.CONTEXT_AS_IS;
            }
        }, tag, false, matchTimeout);
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, null);
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(final WebElement element, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion(element, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.logger.log(String.format("CheckRegion(element, %d, '%s')", matchTimeout, tag));
        this.logger.verbose("Getting current scroll position..");
        Location originalScrollPos = this.driver.getCurrentScrollPosition();
        this.logger.verbose("Done! Getting element's location..");
        Point elementLocation = element.getLocation();
        this.logger.verbose("Done! Trying to scroll to element..");
        this.driver.scrollTo(new Location(elementLocation.getX(), elementLocation.getY()));
        this.logger.verbose("Done! calling checkWindowBase..");
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                Point p = element.getLocation();
                Dimension d = element.getSize();
                return new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight());
            }

            public CoordinatesType getCoordinatesType() {
                return CoordinatesType.CONTEXT_RELATIVE;
            }
        }, tag, false, matchTimeout);
        this.logger.verbose("Done! trying to scroll back to original position..");
        this.driver.scrollTo(originalScrollPos);
        this.logger.verbose("Done!");
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, null);
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag);
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegion(selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.checkRegion(this.driver.findElement(selector), matchTimeout, tag);
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, null);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame(%d, selector, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameIndex);
        this.checkRegion(selector, matchTimeout, tag);
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, null);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame('%s', selector, %d, '%s'): Ignored", frameNameOrId, matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameNameOrId);
        this.checkRegion(selector, matchTimeout, tag);
        this.driver.switchTo().parentFrame();
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, null);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, -1, tag);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckRegionInFrame(frame, selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        this.driver.switchTo().frame(frameReference);
        this.checkRegion(selector, matchTimeout, tag);
        this.driver.switchTo().parentFrame();
    }

    protected void checkCurrentFrame(int matchTimeout, String tag) {
        this.logger.verbose(String.format("CheckCurrentFrame(%d, '%s')", matchTimeout, tag));
        this.checkFrame = true;
        this.logger.verbose("Getting screenshot as base64..");
        String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        this.logger.verbose("Done! Building required object...");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, ImageUtils.imageFromBase64((String)screenshot64));
        this.logger.verbose("Done!");
        this.frameWindowToCheck = screenshot.getFrameWindow();
        super.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return Region.EMPTY;
            }

            public CoordinatesType getCoordinatesType() {
                return null;
            }
        }, tag, false, matchTimeout);
        this.checkFrame = false;
        this.frameWindowToCheck = null;
    }

    public void checkFrame(String frameNameOrId) {
        this.checkFrame(frameNameOrId, -1, null);
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.checkFrame(frameNameOrId, -1, tag);
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%s, %d, '%s'): Ignored", frameNameOrId, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)frameNameOrId, (String)"frameNameOrId");
        this.logger.log(String.format("CheckFrame(%s, %d, '%s')", frameNameOrId, matchTimeout, tag));
        this.logger.verbose("Switching to frame with name/id: " + frameNameOrId + " ...");
        this.driver.switchTo().frame(frameNameOrId);
        this.logger.verbose("Done.");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("CheckFrame(%d, %d, '%s'): Ignored", frameIndex, matchTimeout, tag));
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((int)frameIndex, (String)"frameIndex");
        this.logger.log(String.format("CheckFrame(%d, %d, '%s')", frameIndex, matchTimeout, tag));
        this.logger.verbose("Switching to frame with index: " + frameIndex + " ...");
        this.driver.switchTo().frame(frameIndex);
        this.logger.verbose("Done!");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame...");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkFrame(element, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)frameReference, (String)"frameReference");
        this.logger.log(String.format("CheckFrame(element, %d, '%s')", matchTimeout, tag));
        this.logger.verbose("Switching to frame based on element reference...");
        this.driver.switchTo().frame(frameReference);
        this.logger.verbose("Done!");
        this.checkCurrentFrame(matchTimeout, tag);
        this.logger.verbose("Switching back to parent frame...");
        this.driver.switchTo().parentFrame();
        this.logger.verbose("Done!");
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkFrame(framePath, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)framePath, (String)"framePath");
        ArgumentGuard.greaterThanZero((int)framePath.length, (String)"framePath.length");
        this.logger.log(String.format("checkFrame(framePath, %d, '%s')", matchTimeout, tag));
        FrameChain originalFrameChain = this.driver.getFrameChain();
        this.logger.verbose("Switching to parent frame according to frames path..");
        String[] parentFramePath = new String[framePath.length - 1];
        System.arraycopy(framePath, 0, parentFramePath, 0, parentFramePath.length);
        ((EyesTargetLocator)this.driver.switchTo()).frames(parentFramePath);
        this.logger.verbose("Done! Calling checkFrame..");
        this.checkFrame(framePath[framePath.length - 1], matchTimeout, tag);
        this.logger.verbose("Done! switching to default content..");
        this.driver.switchTo().defaultContent();
        this.logger.verbose("Done! Switching back into the original frame..");
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrameChain);
        this.logger.verbose("Done!");
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, -1, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            this.logger.log(String.format("checkRegionInFrame(framePath, selector, %d, '%s'): Ignored", matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)framePath, (String)"framePath");
        ArgumentGuard.greaterThanZero((int)framePath.length, (String)"framePath.length");
        this.logger.log(String.format("checkFrame(framePath, %d, '%s')", matchTimeout, tag));
        FrameChain originalFrameChain = this.driver.getFrameChain();
        this.logger.verbose("Switching to parent frame according to frames path..");
        String[] parentFramePath = new String[framePath.length - 1];
        System.arraycopy(framePath, 0, parentFramePath, 0, parentFramePath.length);
        ((EyesTargetLocator)this.driver.switchTo()).frames(parentFramePath);
        this.logger.verbose("Done! Calling checkRegionInFrame..");
        this.checkRegionInFrame(framePath[framePath.length - 1], selector, matchTimeout, tag);
        this.logger.verbose("Done! switching back to default content..");
        this.driver.switchTo().defaultContent();
        this.logger.verbose("Done! Switching into the original frame..");
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrameChain);
        this.logger.verbose("Done!");
    }

    public void checkRegionInFrame(String[] framePath, By selector, String tag) {
        this.checkRegionInFrame(framePath, selector, -1, tag);
    }

    public void checkRegionInFrame(String[] framePath, By selector) {
        this.checkRegionInFrame(framePath, selector, -1, null);
    }

    protected void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("AddMouseTrigger: Ignoring %s (disabled)", action));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("AddMouseTrigger: Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("AddMouseTrigger: Ignoring %s (different frame)", action));
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    protected void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("AddMouseTrigger: Ignoring %s (disabled)", action));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("AddMouseTrigger: Ignoring %s (no screenshot)", action));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("AddMouseTrigger: Ignoring %s (different frame)", action));
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    protected void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("AddTextTrigger: Ignoring '%s' (disabled)", text));
            return;
        }
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("AddTextTrigger: Ignoring '%s' (no screenshot)", text));
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            this.logger.verbose(String.format("AddTextTrigger: Ignoring '%s' (different frame)", text));
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    protected void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("AddTextTrigger: Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    protected RectangleSize getViewportSize() {
        try {
            int width = this.driver.extractViewportWidth();
            int height = this.driver.extractViewportHeight();
            return new RectangleSize(width, height);
        }
        catch (Exception ex) {
            this.logger.verbose(String.format("getViewportSize(): Extracting width/height using Javascript is not supported: %s", ex.getMessage()));
            this.logger.verbose("getViewportSize(): Using browser size.");
            Dimension windowSize = this.driver.manage().window().getSize();
            return new RectangleSize(windowSize.getWidth(), windowSize.getHeight());
        }
    }

    protected void setViewportSize(RectangleSize size) {
        Dimension browserSize;
        this.logger.verbose("setViewportSize(" + size + ")");
        int SLEEP = 1000;
        int RETRIES = 3;
        Dimension startingBrowserSize = new Dimension(size.getWidth(), size.getHeight());
        FrameChain originalFrame = this.driver.getFrameChain();
        this.driver.switchTo().defaultContent();
        int retriesLeft = 3;
        this.logger.verbose("Trying to set browser size to: " + startingBrowserSize);
        do {
            this.driver.manage().window().setSize(startingBrowserSize);
            GeneralUtils.sleep((long)1000L);
            browserSize = this.driver.manage().window().getSize();
            this.logger.verbose("Current browser size: " + browserSize);
        } while (--retriesLeft > 0 && !browserSize.equals((Object)startingBrowserSize));
        if (!browserSize.equals((Object)startingBrowserSize)) {
            String errMsg = "Failed to set browser size!";
            this.logger.log(errMsg);
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException(errMsg);
        }
        RectangleSize actualViewportSize = this.getViewportSize();
        this.logger.verbose("setViewportSize(): initial viewport size:" + actualViewportSize);
        this.driver.manage().window().setSize(new Dimension(2 * browserSize.width - actualViewportSize.getWidth(), 2 * browserSize.height - actualViewportSize.getHeight()));
        retriesLeft = 3;
        do {
            GeneralUtils.sleep((long)1000L);
            actualViewportSize = this.getViewportSize();
            this.logger.verbose("setViewportSize(): viewport size: " + actualViewportSize);
        } while (--retriesLeft > 0 && !actualViewportSize.equals((Object)size));
        if (!actualViewportSize.equals((Object)size)) {
            this.logger.verbose("SetViewportSize(): attempting one more time...");
            browserSize = this.driver.manage().window().getSize();
            Dimension updatedBrowserSize = new Dimension(browserSize.width + (size.getWidth() - actualViewportSize.getWidth()), browserSize.height + (size.getHeight() - actualViewportSize.getHeight()));
            this.logger.verbose("SetViewportSize(): browser size: " + browserSize);
            this.logger.verbose("SetViewportSize(): required browser size: " + updatedBrowserSize);
            this.driver.manage().window().setSize(updatedBrowserSize);
            retriesLeft = 3;
            do {
                GeneralUtils.sleep((long)1000L);
                actualViewportSize = this.getViewportSize();
                this.logger.verbose("SetViewportSize(): browser size: " + this.driver.manage().window().getSize());
                this.logger.verbose("setViewportSize(): viewport size: " + actualViewportSize);
            } while (--retriesLeft > 0 && !actualViewportSize.equals((Object)size));
        }
        if (!actualViewportSize.equals((Object)size)) {
            String errMsg = "Failed to set the viewport size.";
            this.logger.log(errMsg);
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
            throw new TestFailedException(errMsg);
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        this.viewportSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EyesScreenshot getScreenshot() {
        this.logger.verbose("getScreenshot()");
        String originalOverflow = null;
        if (this.hideScrollbars) {
            originalOverflow = this.driver.hideScrollbars();
        }
        try {
            EyesWebDriverScreenshot result;
            if (this.checkFrame) {
                this.logger.verbose("Check frame requested");
                BufferedImage entireFrame = this.driver.getStitchedRegion(new RegionProvider(){

                    public Region getRegion() {
                        return Eyes.this.frameWindowToCheck;
                    }

                    public CoordinatesType getCoordinatesType() {
                        return CoordinatesType.SCREENSHOT_AS_IS;
                    }
                });
                this.logger.verbose("Building screenshot object...");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrame, new RectangleSize(entireFrame.getWidth(), entireFrame.getHeight()));
                this.logger.verbose("Done!");
            } else if (this.forceFullPageScreenshot) {
                this.logger.verbose("Full page screenshot requested.");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, this.driver.getFullPageScreenshot());
                this.logger.verbose("Done!");
            } else {
                this.logger.verbose("Screenshot requested...");
                String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                this.logger.verbose("Done! Creating image object...");
                BufferedImage screenshotImage = ImageUtils.imageFromBase64((String)screenshot64);
                this.logger.verbose("Done! Creating screenshot object...");
                result = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
                this.logger.verbose("Done!");
            }
            EyesWebDriverScreenshot eyesWebDriverScreenshot = result;
            return eyesWebDriverScreenshot;
        }
        finally {
            if (this.hideScrollbars) {
                this.driver.setOverflow(originalOverflow);
            }
        }
    }

    protected String getTitle() {
        if (!this.dontGetTitle) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                this.logger.verbose("getTitle(): failed (" + ex.getMessage() + ")");
                this.dontGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected AppEnvironment getEnvironment() {
        AppEnvironment appEnv = super.getEnvironment();
        if (appEnv.getOs() == null) {
            this.logger.verbose("No OS set, checking for mobile OS...");
            try {
                Capabilities capabilities = this.driver.getCapabilities();
                String device = (String)capabilities.getCapability("platformName");
                if (device != null) {
                    String version = (String)capabilities.getCapability("platformVersion");
                    String majorVersion = version != null ? version.split("\\.", 2)[0] : "";
                    appEnv.setOs(device + " " + majorVersion);
                    this.logger.verbose("Found device: " + device);
                }
            }
            catch (Exception e) {
                this.logger.verbose("Failed to extract OS: " + e.getMessage());
            }
        }
        return appEnv;
    }
}

