/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesRemoteWebElement;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Frame {
    protected final Logger logger;
    protected final WebElement reference;
    protected final String id;
    protected final Location location;
    protected final RectangleSize size;
    protected final Location parentScrollPosition;

    public Frame(Logger logger, WebElement reference, String frameId, Location location, RectangleSize size, Location parentScrollPosition) {
        int topBorderWidth;
        int leftBorderWidth;
        String propValue;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)reference, (String)"reference");
        ArgumentGuard.notNull((Object)frameId, (String)"frameId");
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)size, (String)"size");
        ArgumentGuard.notNull((Object)parentScrollPosition, (String)"parentScrollPosition");
        logger.verbose("Frame constructor...");
        this.logger = logger;
        this.reference = reference;
        this.id = frameId;
        this.parentScrollPosition = new Location(parentScrollPosition.getX(), parentScrollPosition.getY());
        this.size = size;
        try {
            logger.verbose("Get frame border left width...");
            if (reference instanceof EyesRemoteWebElement) {
                logger.verbose("Frame reference is an EyesWebElement, using quick version..");
                propValue = ((EyesRemoteWebElement)reference).getComputedStyle("border-left-width");
                logger.verbose("Done!");
            } else {
                logger.verbose("Frame reference is not an EyesWebElement! (when trying to get border-left-width) Element's class: " + reference.getClass().getName());
                logger.verbose("Using getCssValue...");
                propValue = reference.getCssValue("border-left-width");
                logger.verbose("Done!");
            }
            leftBorderWidth = Math.round(Float.valueOf(propValue.trim().replace("px", "")).floatValue());
            logger.verbose("border-left-width: " + leftBorderWidth);
        }
        catch (WebDriverException e) {
            logger.verbose("Got exception while trying to get border-left-width! " + e.getMessage());
            leftBorderWidth = 0;
        }
        try {
            logger.verbose("Get frame border top width...");
            if (reference instanceof EyesRemoteWebElement) {
                logger.verbose("Frame reference is an EyesWebElement, using quick version..");
                propValue = ((EyesRemoteWebElement)reference).getComputedStyle("border-top-width");
                logger.verbose("Done!");
            } else {
                logger.verbose("Frame reference is not an EyesWebElement (when trying to get border-top-width) Element's class: " + reference.getClass().getName());
                logger.verbose("Using getCssValue...");
                propValue = reference.getCssValue("border-top-width");
                logger.verbose("Done!");
            }
            topBorderWidth = Math.round(Float.valueOf(propValue.trim().replace("px", "")).floatValue());
            logger.verbose("border-top-width: " + topBorderWidth);
        }
        catch (WebDriverException e) {
            logger.verbose("Got exception while trying to get border-top-width! " + e.getMessage());
            topBorderWidth = 0;
        }
        Location frameLocation = new Location(location);
        frameLocation.offset(leftBorderWidth, topBorderWidth);
        this.location = frameLocation;
        logger.verbose("Done!");
    }

    public WebElement getReference() {
        return this.reference;
    }

    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public RectangleSize getSize() {
        return this.size;
    }

    public Location getParentScrollPosition() {
        return this.parentScrollPosition;
    }
}

