/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesScreenshotFactory;
import com.applitools.eyes.ImageProvider;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.PositionMemento;
import com.applitools.eyes.PositionProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.ScaleProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class FullPageCaptureAlgorithm {
    private static final int MAX_SCROLL_BAR_SIZE = 50;
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    private final Logger logger;

    public FullPageCaptureAlgorithm(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public BufferedImage getStitchedRegion(ImageProvider imageProvider, RegionProvider regionProvider, PositionProvider originProvider, PositionProvider positionProvider, ScaleProvider scaleProvider, CutProvider cutProvider, int waitBeforeScreenshots, EyesScreenshotFactory screenshotFactory) {
        Location currentPosition;
        this.logger.verbose("getStitchedRegion()");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("Region to check: %s", regionProvider.getRegion()));
        this.logger.verbose(String.format("Coordinates type: %s", regionProvider.getCoordinatesType()));
        int SCALE_MARGIN_PX = 5;
        PositionMemento originalPosition = originProvider.getState();
        int setPositionRetries = 3;
        do {
            positionProvider.setPosition(new Location(0, 0));
            GeneralUtils.sleep((long)waitBeforeScreenshots);
        } while ((currentPosition = positionProvider.getCurrentPosition()).getX() != 0 && currentPosition.getY() != 0 && --setPositionRetries > 0);
        if (currentPosition.getX() != 0 || currentPosition.getY() != 0) {
            originProvider.restoreState(originalPosition);
            throw new EyesException("Couldn't set position to the to the top/left corner!");
        }
        RectangleSize entireSize = positionProvider.getEntireSize();
        this.logger.verbose("Entire size of region context: " + entireSize);
        this.logger.verbose("Getting top/left image...");
        BufferedImage image = imageProvider.getImage();
        image = scaleProvider.scaleImage(image);
        image = cutProvider.cut(image);
        this.logger.verbose("Done! Creating screenshot object...");
        EyesScreenshot screenshot = screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Done! Getting region in screenshot...");
        Region regionInScreenshot = screenshot.convertRegionLocation(regionProvider.getRegion(), regionProvider.getCoordinatesType(), CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Done! Region in screenshot: " + regionInScreenshot);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        if (!regionInScreenshot.isEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)regionInScreenshot);
        }
        if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
            originProvider.restoreState(originalPosition);
            return image;
        }
        RectangleSize partImageSize = new RectangleSize(image.getWidth(), Math.max(image.getHeight() - 50, 10));
        this.logger.verbose(String.format("Total size: %s, image part size: %s", entireSize, partImageSize));
        Region entirePage = new Region(Location.ZERO, entireSize);
        Iterable imageParts = entirePage.getSubRegions(partImageSize);
        this.logger.verbose("Creating stitchedImage container. Size: " + entireSize);
        BufferedImage stitchedImage = new BufferedImage(entireSize.getWidth(), entireSize.getHeight(), image.getType());
        this.logger.verbose("Done! Adding initial screenshot..");
        Raster initialPart = image.getData();
        this.logger.verbose(String.format("Initial part:(0,0)[%d x %d]", initialPart.getWidth(), initialPart.getHeight()));
        stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.logger.verbose("Done!");
        PositionMemento originalStitchedState = positionProvider.getState();
        this.logger.verbose("Getting the rest of the image parts...");
        for (Region partRegion : imageParts) {
            if (partRegion.getLeft() == 0 && partRegion.getTop() == 0) continue;
            this.logger.verbose(String.format("Taking screenshot for %s", partRegion));
            positionProvider.setPosition(partRegion.getLocation());
            GeneralUtils.sleep((long)waitBeforeScreenshots);
            currentPosition = positionProvider.getCurrentPosition();
            this.logger.verbose(String.format("Set position to %s", currentPosition));
            this.logger.verbose("Getting image...");
            BufferedImage partImage = imageProvider.getImage();
            partImage = scaleProvider.scaleImage(partImage);
            partImage = cutProvider.cut(partImage);
            this.logger.verbose("Done!");
            if (!regionInScreenshot.isEmpty()) {
                partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)regionInScreenshot);
            }
            this.logger.verbose("Stitching part into the image container...");
            stitchedImage.getRaster().setRect(currentPosition.getX(), currentPosition.getY(), partImage.getData());
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Stitching done!");
        positionProvider.restoreState(originalStitchedState);
        originProvider.restoreState(originalPosition);
        return stitchedImage;
    }
}

