/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.Configuration;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.IConfigurationGetter;
import com.applitools.eyes.selenium.IConfigurationSetter;
import com.applitools.eyes.selenium.ISeleniumConfigurationProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.rendering.VisualGridEyes;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.utils.ArgumentGuard;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Eyes
implements ISeleniumConfigurationProvider {
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private boolean isVisualGridEyes = false;
    private VisualGridEyes visualGridEyes = null;
    private SeleniumEyes seleniumEyes = null;
    private EyesRunner runner = null;
    private Configuration configuration = new Configuration();
    private EyesWebDriver driver;
    private ImageRotation rotation;

    public Eyes() {
        this.seleniumEyes = new SeleniumEyes(this, (ClassicRunner)this.runner);
    }

    public Eyes(EyesRunner runner) {
        EyesRunner eyesRunner = this.runner = runner == null ? new ClassicRunner() : runner;
        if (this.runner instanceof VisualGridRunner) {
            this.visualGridEyes = new VisualGridEyes((VisualGridRunner)this.runner, this);
            this.isVisualGridEyes = true;
        } else {
            this.seleniumEyes = new SeleniumEyes(this, (ClassicRunner)runner);
        }
    }

    public WebDriver open(WebDriver webDriver) {
        if (this.isVisualGridEyes) {
            return this.visualGridEyes.open(webDriver);
        }
        return this.seleniumEyes.open(webDriver);
    }

    public void setServerUrl(String serverUrl) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setServerUrl(serverUrl);
        } else {
            this.seleniumEyes.setServerUrl(serverUrl);
        }
    }

    public void setServerUrl(URI serverUri) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setServerUrl(serverUri.toString());
        } else {
            this.seleniumEyes.setServerUrl(serverUri.toString());
        }
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        this.configuration.setProxy(proxySettings);
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setProxy(proxySettings);
        }
    }

    public void setIsDisabled(Boolean isDisabled) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setIsDisabled(isDisabled);
        } else {
            this.seleniumEyes.setIsDisabled(isDisabled);
        }
    }

    public void check(ICheckSettings checkSettings) {
        this.check((String)null, checkSettings);
    }

    public TestResults close() {
        return this.close(true);
    }

    public TestResults abortIfNotClosed() {
        return this.abort();
    }

    public TestResults abort() {
        TestResults testResults;
        if (this.isVisualGridEyes) {
            Collection<Future<TestResultContainer>> futures = this.visualGridEyes.abortIfNotClosed();
            testResults = this.parseCloseFutures(futures, false);
        } else {
            testResults = this.seleniumEyes.abortIfNotClosed();
        }
        return testResults;
    }

    public boolean getIsDisabled() {
        if (this.isVisualGridEyes) {
            return this.visualGridEyes.getIsDisabled();
        }
        return this.seleniumEyes.getIsDisabled();
    }

    public String getApiKey() {
        if (this.isVisualGridEyes) {
            return this.visualGridEyes.getApiKey();
        }
        return this.seleniumEyes.getApiKey();
    }

    public void setApiKey(String apiKey) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setApiKey(apiKey);
        } else {
            this.seleniumEyes.setApiKey(apiKey);
        }
    }

    public void setBranchName(String branchName) {
        if (this.configuration != null) {
            this.configuration.setBranchName(branchName);
        }
        this.configuration.setBranchName(branchName);
    }

    public void setParentBranchName(String branchName) {
        this.configuration.setParentBranchName(branchName);
    }

    public void setHideCaret(boolean hideCaret) {
        this.configuration.setHideCaret(hideCaret);
    }

    public void setMatchTimeout(int ms) {
        this.configuration.setMatchTimeout(ms);
    }

    public int getMatchTimeout() {
        return this.configuration.getMatchTimeout();
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.configuration.setSaveNewTests(saveNewTests);
    }

    public boolean getSaveNewTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.configuration.setSaveFailedTests(saveFailedTests);
    }

    public boolean getSaveFailedTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setBatch(BatchInfo batch) {
        this.configuration.setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.configuration.getBatch();
    }

    public void setFailureReports(FailureReports failureReports) {
        this.configuration.setFailureReports(failureReports);
    }

    public FailureReports getFailureReports() {
        return this.configuration.getFailureReports();
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.configuration.setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configuration.getDefaultMatchSettings();
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.configuration.getDefaultMatchSettings().setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.configuration.getDefaultMatchSettings().getMatchLevel();
    }

    public String getFullAgentId() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getFullAgentId();
        }
        return this.visualGridEyes.getFullAgentId();
    }

    public boolean getIsOpen() {
        if (this.isVisualGridEyes) {
            return this.visualGridEyes.getIsOpen();
        }
        return this.seleniumEyes.getIsOpen();
    }

    public static URI getDefaultServerUrl() {
        return SeleniumEyes.getDefaultServerUrl();
    }

    public void setLogHandler(LogHandler logHandler) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setLogHandler(logHandler);
        } else {
            this.seleniumEyes.setLogHandler(logHandler);
        }
    }

    public LogHandler getLogHandler() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getLogHandler();
        }
        if (this.visualGridEyes.getLogger() != null) {
            return this.visualGridEyes.getLogger().getLogHandler();
        }
        return null;
    }

    public Logger getLogger() {
        if (this.isVisualGridEyes) {
            return this.visualGridEyes.getLogger();
        }
        return this.seleniumEyes.getLogger();
    }

    public void setImageCut(CutProvider cutProvider) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setImageCut(cutProvider);
        }
    }

    public boolean getIsCutProviderExplicitlySet() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getIsCutProviderExplicitlySet();
        }
        return false;
    }

    public void check(String tag, ICheckSettings checkSettings) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.check(tag, checkSettings);
        } else {
            this.seleniumEyes.check(tag, checkSettings);
        }
    }

    public TestResults close(boolean shouldThrowException) {
        if (this.isVisualGridEyes) {
            Collection<Future<TestResultContainer>> close = this.visualGridEyes.close(shouldThrowException);
            return this.parseCloseFutures(close, shouldThrowException);
        }
        TestResults close = this.seleniumEyes.close(shouldThrowException);
        return close;
    }

    private TestResults parseCloseFutures(Collection<Future<TestResultContainer>> close, boolean shouldThrowException) {
        if (close != null && !close.isEmpty()) {
            TestResultContainer errorResult = null;
            TestResultContainer firstResult = null;
            try {
                for (Future<TestResultContainer> closeFuture : close) {
                    Throwable error;
                    TestResultContainer testResultContainer = closeFuture.get();
                    if (firstResult == null) {
                        firstResult = testResultContainer;
                    }
                    if ((error = testResultContainer.getException()) == null || errorResult != null) continue;
                    errorResult = testResultContainer;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            if (errorResult != null) {
                if (shouldThrowException) {
                    throw new Error(errorResult.getException());
                }
                return errorResult.getTestResults();
            }
            if (firstResult != null) {
                return firstResult.getTestResults();
            }
        }
        return null;
    }

    public void setScaleRatio(Double scaleRatio) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setScaleRatio(scaleRatio);
        }
    }

    public double getScaleRatio() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getScaleRatio();
        }
        return 0.0;
    }

    public void addProperty(String name, String value) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.addProperty(name, value);
        } else {
            this.visualGridEyes.addProperty(name, value);
        }
    }

    public void clearProperties() {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.clearProperties();
        } else {
            this.visualGridEyes.clearProperties();
        }
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setSaveDebugScreenshots(saveDebugScreenshots);
        }
    }

    public boolean getSaveDebugScreenshots() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getSaveDebugScreenshots();
        }
        return false;
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setDebugScreenshotsPath(pathToSave);
        }
    }

    public String getDebugScreenshotsPath() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getDebugScreenshotsPath();
        }
        return null;
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setDebugScreenshotsPrefix(prefix);
        }
    }

    public String getDebugScreenshotsPrefix() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getDebugScreenshotsPrefix();
        }
        return null;
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getDebugScreenshotsProvider();
        }
        return null;
    }

    public boolean getIgnoreCaret() {
        return this.configuration.getIgnoreCaret();
    }

    public void setIgnoreCaret(boolean value) {
        if (!this.isVisualGridEyes) {
            this.configuration.setIgnoreCaret(value);
        }
    }

    public int getStitchOverlap() {
        return this.configuration.getStitchOverlap();
    }

    public void setStitchOverlap(int pixels) {
        if (!this.isVisualGridEyes) {
            this.configuration.setStitchOverlap(pixels);
        }
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(Region region, int matchTimeout, String tag) throws TestFailedException {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("checkRegion([%s], %d, '%s'): Ignored", region, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.getLogger().verbose(String.format("checkRegion([%s], %d, '%s')", region, matchTimeout, tag));
        this.check((ICheckSettings)Target.region(region).timeout(matchTimeout).withName(tag));
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, -1, null, true);
    }

    public void checkRegion(WebElement element, boolean stitchContent) {
        this.checkRegion(element, -1, null, stitchContent);
    }

    public void checkRegion(WebElement element, String tag) {
        this.checkRegion(element, -1, tag);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.checkRegion(element, -1, tag, stitchContent);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag) {
        this.checkRegion(element, matchTimeout, tag, true);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("checkRegion([%s], %d, '%s'): Ignored", element, matchTimeout, tag));
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.getLogger().verbose(String.format("checkRegion([%s], %d, '%s')", element, matchTimeout, tag));
        this.check((ICheckSettings)Target.region(element).timeout(matchTimeout).withName(tag).fully(stitchContent));
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, -1, null, false);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.checkRegion(selector, -1, null, stitchContent);
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag, true);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.checkRegion(selector, -1, tag, stitchContent);
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        this.checkRegion(selector, matchTimeout, tag, true);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector) {
        this.checkRegionInFrame(frameIndex, selector, null);
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(int frameIndex, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, null, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag);
    }

    public void checkRegionInFrame(int frameIndex, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameIndex, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(int frameIndex, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameIndex, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector) {
        this.checkRegionInFrame(frameNameOrId, selector, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, null, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameNameOrId, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameNameOrId, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(String frameNameOrId, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkRegionInFrame(WebElement frameReference, By selector) {
        this.checkRegionInFrame(frameReference, selector, -1, null);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, null, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, true);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, String tag, boolean stitchContent) {
        this.checkRegionInFrame(frameReference, selector, -1, tag, stitchContent);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag) {
        this.checkRegionInFrame(frameReference, selector, matchTimeout, tag, true);
    }

    public void checkRegionInFrame(WebElement frameReference, By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkElement(WebElement element) {
        this.checkElement(element, null);
    }

    public void checkElement(WebElement element, String tag) {
        this.checkElement(element, -1, tag);
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.checkElement(selector, -1, null);
    }

    public void checkElement(By selector, String tag) {
        this.checkElement(selector, -1, tag);
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.addMouseTrigger(action, control, cursor);
        }
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.addMouseTrigger(action, element);
        }
    }

    public void addTextTrigger(Region control, String text) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.addTextTrigger(control, text);
        }
    }

    public void addTextTrigger(WebElement element, String text) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.addTextTrigger(element, text);
        }
    }

    public RectangleSize getViewportSize() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getViewportSize();
        }
        return null;
    }

    public static RectangleSize getViewportSize(WebDriver driver) {
        return SeleniumEyes.getViewportSize(driver);
    }

    public static void setViewportSize(WebDriver driver, RectangleSize size) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        EyesSeleniumUtils.setViewportSize(new Logger(), driver, size);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        RectangleSize viewportSize = SeleniumEyes.getViewportSize(driver);
        this.configuration.setAppName(appName);
        this.configuration.setTestName(testName);
        this.configuration.setViewportSize(viewportSize);
        return this.open(driver);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.configuration.setAppName(appName);
        this.configuration.setTestName(testName);
        this.configuration.setViewportSize(viewportSize);
        return this.open(driver);
    }

    public boolean getHideCaret() {
        return this.configuration.getHideCaret();
    }

    public boolean shouldStitchContent() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.shouldStitchContent();
        }
        return false;
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.configuration.setForceFullPageScreenshot(shouldForce);
    }

    public boolean getForceFullPageScreenshot() {
        Boolean forceFullPageScreenshot = this.configuration.getForceFullPageScreenshot();
        if (forceFullPageScreenshot == null) {
            return this.isVisualGridEyes;
        }
        return forceFullPageScreenshot;
    }

    public void setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.configuration.setWaitBeforeScreenshots(waitBeforeScreenshots);
    }

    public int getWaitBeforeScreenshots() {
        return this.configuration.getWaitBeforeScreenshots();
    }

    public void setScrollToRegion(boolean shouldScroll) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setScrollToRegion(shouldScroll);
        }
    }

    public boolean getScrollToRegion() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getScrollToRegion();
        }
        return false;
    }

    public void setStitchMode(StitchMode mode) {
        this.configuration.setStitchMode(mode);
    }

    public StitchMode getStitchMode() {
        return this.configuration.getStitchMode();
    }

    public void setHideScrollbars(boolean shouldHide) {
        this.configuration.setHideScrollbars(shouldHide);
    }

    public boolean getHideScrollbars() {
        return this.configuration.getHideScrollbars();
    }

    public ImageRotation getRotation() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getRotation();
        }
        return null;
    }

    public void setRotation(ImageRotation rotation) {
        WebDriver driver;
        this.rotation = rotation;
        if (!this.isVisualGridEyes && (driver = this.getDriver()) != null) {
            ((EyesWebDriver)driver).setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getDevicePixelRatio();
        }
        return 0.0;
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    public void checkWindow(String tag, boolean fully) {
        this.check(tag, (ICheckSettings)Target.window().fully(fully));
    }

    public void check(ICheckSettings ... checkSettings) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.check(checkSettings);
        } else {
            for (ICheckSettings checkSetting : checkSettings) {
                this.visualGridEyes.check(checkSetting);
            }
        }
    }

    public void checkFrame(String frameNameOrId) {
        this.checkFrame(frameNameOrId, null);
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.checkFrame(frameNameOrId, -1, tag);
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully().timeout(matchTimeout));
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout));
    }

    public void checkFrame(String[] framesPath, String tag) {
        this.checkFrame(framesPath, -1, tag);
    }

    public void checkFrame(String[] framesPath) {
        this.checkFrame(framesPath, null);
    }

    public URI getServerUrl() {
        if (this.isVisualGridEyes) {
            return this.visualGridEyes.getServerUrl();
        }
        return this.seleniumEyes.getServerUrl();
    }

    public void setAgentId(String agentId) {
        this.configuration.setAgentId(agentId);
    }

    public String getAgentId() {
        return this.configuration.getAgentId();
    }

    public void setServerConnector(IServerConnector serverConnector) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.setServerConnector(serverConnector);
        }
    }

    public AbstractProxySettings getProxy() {
        return this.configuration.getProxy();
    }

    public void setAppName(String appName) {
        this.configuration.setAppName(appName);
    }

    public String getAppName() {
        return this.configuration.getAppName();
    }

    public String getHostOS() {
        return this.configuration.getHostOS();
    }

    public String getHostApp() {
        return this.configuration.getHostOS();
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.configuration.setBaselineEnvName(baselineEnvName);
    }

    public String getBaselineEnvName() {
        return this.configuration.getBaselineEnvName();
    }

    public void setEnvName(String envName) {
        this.configuration.setEnvironmentName(envName);
    }

    public String getEnvName() {
        return this.configuration.getEnvironmentName();
    }

    public PositionProvider getPositionProvider() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getPositionProvider();
        }
        return null;
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setPositionProvider(positionProvider);
        }
    }

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setExplicitViewportSize(explicitViewportSize);
        }
    }

    public Object getAgentSetup() {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.getAgentSetup();
        }
        return null;
    }

    public void log(String message) {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.getLogger().log(message);
        } else {
            this.seleniumEyes.log(message);
        }
    }

    public void addSessionEventHandler(ISessionEventHandler eventHandler) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.addSessionEventHandler(eventHandler);
        }
    }

    public void removeSessionEventHandler(ISessionEventHandler eventHandler) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.removeSessionEventHandler(eventHandler);
        }
    }

    public void clearSessionEventHandlers() {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.clearSessionEventHandlers();
        }
    }

    public boolean isSendDom() {
        return this.configuration.isSendDom();
    }

    public void setSendDom(boolean isSendDom) {
        this.configuration.setSendDom(isSendDom);
    }

    public void setHostOS(String hostOS) {
        this.configuration.setHostOS(hostOS);
    }

    public void setHostApp(String hostApp) {
        this.configuration.setHostApp(hostApp);
    }

    public RenderingInfo getRenderingInfo() {
        return null;
    }

    public String getBranchName() {
        return this.configuration.getBranchName();
    }

    public String getParentBranchName() {
        return this.configuration.getParentBranchName();
    }

    public void setBaselineBranchName(String branchName) {
        this.configuration.setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configuration.getBaselineBranchName();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.configuration.setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configuration.getSaveDiffs();
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public WebDriver getDriver() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getDriver();
        }
        return this.visualGridEyes.getDriver();
    }

    public FrameChain getOriginalFC() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getOriginalFC();
        }
        return null;
    }

    public PositionProvider getCurrentFramePositionProvider() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getCurrentFramePositionProvider();
        }
        return null;
    }

    public Region getRegionToCheck() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getRegionToCheck();
        }
        return null;
    }

    public void setRegionToCheck(Region regionToCheck) {
        if (!this.isVisualGridEyes) {
            this.seleniumEyes.setRegionToCheck(regionToCheck);
        }
    }

    public WebElement getCurrentFrameScrollRootElement() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getCurrentFrameScrollRootElement();
        }
        return null;
    }

    public IServerConnector getServerConnector() {
        if (!this.isVisualGridEyes) {
            return this.seleniumEyes.getServerConnector();
        }
        return null;
    }

    public IConfigurationGetter get() {
        return this.configuration;
    }

    public IConfigurationSetter set() {
        return this.configuration;
    }

    public Configuration getConfiguration() {
        return new Configuration((IConfigurationGetter)this.configuration);
    }

    public void setConfiguration(Configuration configuration) {
        AbstractProxySettings proxy;
        URI serverUrl;
        ArgumentGuard.notNull((Object)configuration, (String)"configuration");
        String apiKey = configuration.getApiKey();
        if (apiKey != null) {
            this.setApiKey(apiKey);
        }
        if ((serverUrl = configuration.getServerUrl()) != null) {
            this.setServerUrl(serverUrl.toString());
        }
        if ((proxy = configuration.getProxy()) != null) {
            this.setProxy(proxy);
        }
        this.configuration = new Configuration((IConfigurationGetter)configuration);
    }

    public void closeAsync() {
        if (this.isVisualGridEyes) {
            this.visualGridEyes.closeAsync();
        } else {
            this.seleniumEyes.close(false);
        }
    }
}

