/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.IDownloadListener;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.ScriptResponse;
import com.applitools.eyes.selenium.capture.Separators;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.EfficientStringReplace;
import com.applitools.utils.GeneralUtils;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriterSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class DomCapture {
    private static String CAPTURE_FRAME_SCRIPT;
    private final Phaser cssPhaser = new Phaser();
    private static long DOM_EXTRACTION_TIMEOUT;
    private static IServerConnector mServerConnector;
    private EyesWebDriver driver;
    private final Logger logger;
    private String cssStartToken;
    private String cssEndToken;
    private Map<String, String> cssData = Collections.synchronizedMap(new HashMap());
    private boolean shouldWaitForPhaser = false;
    private AtomicBoolean isCheckTimerTimedOut = new AtomicBoolean(false);
    private Timer timer = new Timer("DomCapture_StopWatch", true);

    public DomCapture(SeleniumEyes eyes) {
        mServerConnector = eyes.getServerConnector();
        this.logger = eyes.getLogger();
        this.driver = (EyesWebDriver)eyes.getDriver();
    }

    public String getFullWindowDom() {
        long currentTimeMillis = System.currentTimeMillis();
        String domJson = this.getDom();
        String timeDiff = String.valueOf(System.currentTimeMillis() - currentTimeMillis);
        this.logger.verbose("getting th DOM took " + timeDiff + " ms");
        return domJson;
    }

    public String getFullWindowDom(PositionProvider positionProvider) {
        PositionMemento originalPosition = positionProvider.getState();
        positionProvider.setPosition(Location.ZERO);
        String domJson = this.getDom();
        positionProvider.restoreState(originalPosition);
        return domJson;
    }

    private String getDom() {
        FrameChain originalFC = this.driver.getFrameChain();
        String dom = this.getFrameDom();
        if (originalFC != null) {
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFC);
        }
        try {
            if (this.shouldWaitForPhaser) {
                this.cssPhaser.awaitAdvanceInterruptibly(0, 30L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        String inlaidString = EfficientStringReplace.efficientStringReplace((String)this.cssStartToken, (String)this.cssEndToken, (String)dom, this.cssData);
        return inlaidString;
    }

    private String getFrameDom() {
        this.logger.verbose("Trying to get DOM from driver");
        this.timer.schedule((TimerTask)new TimeoutTask(), DOM_EXTRACTION_TIMEOUT);
        try {
            this.isCheckTimerTimedOut.set(false);
            ScriptResponse.Status status = null;
            ScriptResponse scriptResponse = null;
            do {
                String resultAsString = (String)this.driver.executeScript(CAPTURE_FRAME_SCRIPT + "return __captureDomAndPoll();", new Object[0]);
                try {
                    scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
                    status = scriptResponse.getStatus();
                }
                catch (IOException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                }
                Thread.sleep(200L);
            } while (status == ScriptResponse.Status.WIP && !this.isCheckTimerTimedOut.get());
            if (status == ScriptResponse.Status.ERROR) {
                throw new EyesException("DomCapture Error: " + scriptResponse.getError());
            }
            if (this.isCheckTimerTimedOut.get()) {
                throw new EyesException("DomCapture Timed out");
            }
            String executeScripString = scriptResponse.getValue();
            ArrayList<String> missingCssList = new ArrayList<String>();
            ArrayList<String> missingFramesList = new ArrayList<String>();
            ArrayList<String> data = new ArrayList<String>();
            Separators separators = this.parseScriptResult(executeScripString, missingCssList, missingFramesList, data);
            this.cssStartToken = separators.cssStartToken;
            this.cssEndToken = separators.cssEndToken;
            this.fetchCssFiles(missingCssList);
            Map<String, String> framesData = null;
            try {
                framesData = this.recurseFrames(missingFramesList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String inlaidString = EfficientStringReplace.efficientStringReplace((String)separators.iframeStartToken, (String)separators.iframeEndToken, (String)((String)data.get(0)), framesData);
            this.timer.cancel();
            return inlaidString;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.timer.cancel();
            return "";
        }
    }

    private Map<String, String> recurseFrames(List<String> missingFramesList) {
        HashMap<String, String> framesData = new HashMap<String, String>();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fc = this.driver.getFrameChain().clone();
        for (String missingFrameLine : missingFramesList) {
            this.logger.verbose("Switching to frame line :" + missingFrameLine);
            String originLocation = (String)this.driver.executeScript("return document.location.href", new Object[0]);
            try {
                String[] missingFrameXpaths;
                for (String missingFrameXpath : missingFrameXpaths = missingFrameLine.split(",")) {
                    this.logger.verbose("switching to specific frame : " + missingFrameXpath);
                    WebElement frame = this.driver.findElement(By.xpath((String)missingFrameXpath));
                    this.logger.verbose("Switched to frame(" + missingFrameXpath + ") with src(" + frame.getAttribute("src") + ")");
                    switchTo.frame(frame);
                }
                String locationAfterSwitch = (String)this.driver.executeScript("return document.location.href", new Object[0]);
                if (locationAfterSwitch.equals(originLocation)) {
                    this.logger.verbose("Switching to frame failed");
                    framesData.put(missingFrameLine, "");
                    continue;
                }
                String result = this.getFrameDom();
                framesData.put(missingFrameLine, result);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                framesData.put(missingFrameLine, "");
            }
            switchTo.frames(fc);
        }
        return framesData;
    }

    private void fetchCssFiles(List<String> missingCssList) {
        for (final String missingCssUrl : missingCssList) {
            if (missingCssUrl.startsWith("blob:")) {
                this.logger.log("Found blob url continuing - " + missingCssUrl);
                continue;
            }
            if (missingCssUrl.isEmpty()) continue;
            try {
                final CssTreeNode cssTreeNode = new CssTreeNode(new URL(missingCssUrl));
                this.downloadCss(cssTreeNode, new IDownloadListener<String>(){

                    public void onDownloadComplete(String downloadedString, String contentType) {
                        DomCapture.this.logger.verbose("DomCapture.onDownloadComplete");
                        DomCapture.this.parseCSS(cssTreeNode, downloadedString);
                        if (cssTreeNode.allImportRules != null && !cssTreeNode.allImportRules.isEmpty()) {
                            cssTreeNode.downloadNodeCss();
                        }
                        DomCapture.this.cssData.put(missingCssUrl, EfficientStringReplace.CleanForJSON((String)cssTreeNode.calcCss()));
                    }

                    public void onDownloadFailed() {
                        DomCapture.this.logger.verbose("DomCapture.onDownloadFailed");
                        DomCapture.this.cssData.put(missingCssUrl, "");
                    }
                });
            }
            catch (MalformedURLException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
    }

    private Separators parseScriptResult(String scriptResult, List<String> missingCssList, List<String> missingFramesList, List<String> data) {
        String[] lines = scriptResult.split("\\r?\\n");
        Separators separators = null;
        try {
            separators = (Separators)GeneralUtils.parseJsonToObject((String)lines[0], Separators.class);
            ArrayList<List<String>> blocks = new ArrayList<List<String>>();
            blocks.add(missingCssList);
            blocks.add(missingFramesList);
            blocks.add(data);
            int blockIndex = 0;
            int lineIndex = 1;
            do {
                String str;
                if (separators.separator.equals(str = lines[lineIndex++])) {
                    ++blockIndex;
                    continue;
                }
                ((List)blocks.get(blockIndex)).add(str);
            } while (lineIndex < lines.length);
            this.logger.verbose("missing css count: " + missingCssList.size());
            this.logger.verbose("missing frames count: " + missingFramesList.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.shouldWaitForPhaser |= !missingCssList.isEmpty();
        return separators;
    }

    private void downloadCss(final CssTreeNode node, final IDownloadListener<String> listener) {
        this.cssPhaser.register();
        this.logger.verbose("Given URL to download: " + node.url);
        mServerConnector.downloadString(node.url, false, (IDownloadListener)new IDownloadListener<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDownloadComplete(String downloadedString, String contentType) {
                try {
                    DomCapture.this.logger.verbose("Download Complete");
                    node.setCss(downloadedString);
                    listener.onDownloadComplete((Object)downloadedString, "String");
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace((Logger)DomCapture.this.logger, (Throwable)e);
                }
                finally {
                    DomCapture.this.cssPhaser.arriveAndDeregister();
                    DomCapture.this.logger.verbose("cssPhaser.arriveAndDeregister(); " + node.url);
                    DomCapture.this.logger.verbose("current missing - " + DomCapture.this.cssPhaser.getUnarrivedParties());
                }
            }

            public void onDownloadFailed() {
                listener.onDownloadComplete((Object)"", "String");
                DomCapture.this.cssPhaser.arriveAndDeregister();
                DomCapture.this.logger.verbose("Download Failed");
                DomCapture.this.logger.verbose("cssPhaser.arriveAndDeregister(); " + node.url);
                DomCapture.this.logger.verbose("current missing  - " + DomCapture.this.cssPhaser.getUnarrivedParties());
            }
        });
    }

    private void parseCSS(CssTreeNode node, String css) {
        if (css == null) {
            return;
        }
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString((String)css, (ECSSVersion)ECSSVersion.CSS30);
        if (cascadingStyleSheet == null) {
            return;
        }
        ICommonsList allRules = cascadingStyleSheet.getAllRules();
        if (allRules.isEmpty()) {
            return;
        }
        ICommonsList allImportRules = cascadingStyleSheet.getAllImportRules();
        node.setAllImportRules((ICommonsList<CSSImportRule>)allImportRules);
        node.setAllStyleRules((ICommonsList<CSSStyleRule>)cascadingStyleSheet.getAllStyleRules());
    }

    static {
        try {
            CAPTURE_FRAME_SCRIPT = GeneralUtils.readToEnd((InputStream)DomCapture.class.getResourceAsStream("/captureDomAndPoll.js"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DOM_EXTRACTION_TIMEOUT = 300000L;
        mServerConnector = null;
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            DomCapture.this.logger.verbose("Check Timer timeout.");
            DomCapture.this.isCheckTimerTimedOut.set(true);
        }
    }

    class CssTreeNode {
        URL url;
        String css = "";
        StringBuilder sb = new StringBuilder();
        List<CssTreeNode> decedents = new ArrayList<CssTreeNode>();
        ICommonsList<CSSImportRule> allImportRules;
        ICommonsList<CSSStyleRule> styleRules;

        public CssTreeNode(URL url) {
            this.url = url;
        }

        String calcCss() {
            this.sb.append(this.css);
            if (this.decedents != null) {
                for (CssTreeNode decedent : this.decedents) {
                    this.sb.append(decedent.calcCss());
                }
            }
            if (this.styleRules != null) {
                for (CSSStyleRule styleRule : this.styleRules) {
                    this.sb.append(styleRule.getAsCSSString((ICSSWriterSettings)new CSSWriterSettings()));
                }
            }
            return this.sb.toString();
        }

        public void setCss(String css) {
            this.css = css;
        }

        void downloadNodeCss() {
            if (this.allImportRules != null) {
                for (CSSImportRule importRule : this.allImportRules) {
                    try {
                        final CssTreeNode cssTreeNode = new CssTreeNode(new URL(importRule.getLocation().getURI()));
                        String uri = importRule.getLocation().getURI();
                        cssTreeNode.setUrl(uri);
                        DomCapture.this.downloadCss(cssTreeNode, (IDownloadListener<String>)((IDownloadListener)new IDownloadListener<String>(){

                            public void onDownloadComplete(String downloadedString, String contentType) {
                                DomCapture.this.parseCSS(cssTreeNode, EfficientStringReplace.CleanForJSON((String)downloadedString));
                                if (!cssTreeNode.allImportRules.isEmpty()) {
                                    cssTreeNode.downloadNodeCss();
                                }
                            }

                            public void onDownloadFailed() {
                                DomCapture.this.logger.verbose("Download Failed");
                            }
                        }));
                        this.decedents.add(cssTreeNode);
                    }
                    catch (MalformedURLException e) {
                        GeneralUtils.logExceptionStackTrace((Logger)DomCapture.this.logger, (Throwable)e);
                    }
                }
            }
        }

        public void setUrl(String url) {
            boolean absolute = false;
            try {
                url = URLEncoder.encode(url, "UTF-8");
                absolute = new URI(url).isAbsolute();
                this.url = absolute ? new URL(url) : new URL(url);
            }
            catch (UnsupportedEncodingException | MalformedURLException | URISyntaxException e) {
                GeneralUtils.logExceptionStackTrace((Logger)DomCapture.this.logger, (Throwable)e);
            }
        }

        public void setAllImportRules(ICommonsList<CSSImportRule> allImportRules) {
            this.allImportRules = allImportRules;
        }

        public void setAllStyleRules(ICommonsList<CSSStyleRule> allStyleRules) {
            this.styleRules = allStyleRules;
        }
    }
}

