/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IDriverProvider;
import com.applitools.eyes.IGetAccessibilityRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.IGetAccessibilityRegionType;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AccessibilityRegionByElement
implements IGetAccessibilityRegion,
IGetSeleniumRegion,
IGetAccessibilityRegionType {
    private AccessibilityRegionType regionType;
    private WebElement element;

    public AccessibilityRegionByElement(WebElement element, AccessibilityRegionType regionType) {
        this.element = element;
        this.regionType = regionType;
    }

    public List<AccessibilityRegionByRectangle> getRegions(IDriverProvider eyesBase, EyesScreenshot screenshot) {
        Point p = this.element.getLocation();
        Location pTag = screenshot.convertLocation(new Location(p.x, p.y), CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        return Arrays.asList(new AccessibilityRegionByRectangle(new Region(pTag, new RectangleSize(this.element.getSize().width, this.element.getSize().height)), this.regionType));
    }

    public AccessibilityRegionType getAccessibilityRegionType() {
        return this.regionType;
    }

    @Override
    public List<WebElement> getElements(WebDriver driver) {
        return Arrays.asList(this.element);
    }
}

